/******************************************************************************
 * mod_uploader / CGIUploaderConfig.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: CGIUploaderConfig.h 890 2005-10-22 14:19:34Z svn $
 *****************************************************************************/

#ifndef CGI_UPLOADER_CONFIG_H
#define CGI_UPLOADER_CONFIG_H

#include "RFC1867ParserImpl.h"
#include "UploaderConfig.h"

#include "apr_pools.h"

#include <cstdlib>

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

using namespace std;

/**
 * @brief åץݻ륯饹
 */
class CGIUploaderConfig : public UploaderConfig {
public:
    static const char URL_PARAM[];
    static const char FILE_DIRECTORY_PARAM[];
    static const char THUMB_DIRECTORY_PARAM[];
    static const char TMP_DIRECTORY_PARAM[];
    static const char VIEW_TEMPLATE_FILE_PARAM[];
    static const char PROGRESS_TEMPLATE_FILE_PARAM[];
    static const char DOWNLOAD_TEMPLATE_FILE_PARAM[];
    static const char THUMB_TEMPLATE_FILE_PARAM[];
    static const char ERROR_TEMPLATE_FILE_PARAM[];
    static const char MAX_FILE_SIZE_PARAM[];
    static const char TOTAL_FILE_SIZE_LIMIT_PARAM[];
    static const char TOTAL_FILE_NUMBER_LIMIT_PARAM[];
    static const char PER_PAGE_ITEM_NUMBER_PARAM[];

    ~CGIUploaderConfig();

    void write_lock();
    void write_unlock();

    static CGIUploaderConfig *load(apr_pool_t *pool, const char *config_path);

    CGIRFC1867Parser *uparser;

private:
    static const char LOCK_FILE_NAME[];

    CGIUploaderConfig();
    void init(apr_pool_t *pool);

    apr_file_t *lock_file_;
};

typedef CGIUploaderConfig uconfig;

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
