/******************************************************************************
 * mod_uploader / DirectoryCleaner.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not bcktuired.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: BinString.h 441 2005-07-08 20:14:06Z svn $
 *****************************************************************************/

#ifndef DIRECTORY_CLEANER_H
#define DIRECTORY_CLEANER_H

#define __STDC_CONSTANT_MACROS

#include "apr.h"
#include "apr_pools.h"

#include <cstdlib>

using namespace std;

/**
 * @brief ǥ쥯ȥݽԤ饹
 */
class DirectoryCleaner
{
public:
    /**
     * ǥ쥯ȥˤŤեޤ
     *
     * mtime ߻ threshold_sec ðʾŤΤоݤ
     * ʤޤե̾.פǻϤޤʪ̵뤵ޤ
     *
     * @param[in] pool ס
     * @param[in] dir_path оݥǥ쥯ȥΥѥ
     * @param[in] threshold_sec ٤ɤδ
     * @exception const char * եκ˼Ԥ
     */
    static void cleanOldFiles(apr_pool_t *pool,
                              const char *dir_path, apr_size_t threshold_sec);

    DirectoryCleaner(const DirectoryCleaner&);
    DirectoryCleaner &operator=(const DirectoryCleaner&);
};

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
