/******************************************************************************
 * mod_uploader / FileResponseWriter.cpp
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: FileResponseWriter.h 874 2005-10-21 19:02:10Z svn $
 *****************************************************************************/

#ifndef FILE_RESPONSE_WRITER_H
#define FILE_RESPONSE_WRITER_H

#include "ResponseWriter.h"

#define APR_WANT_STDIO
#include "apr_want.h"

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

using namespace std;

/**
 * @brief եإ쥹ݥ󥹤񤭽Ф饹
 */
class FileResponseWriter : public ResponseWriter
{
public:
    FileResponseWriter();
    ~FileResponseWriter();

    void puts(const char *str)
    {
        apr_file_puts(str, file_);
    };

private:
    static const apr_size_t BUFFER_SIZE = 8192;
};

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
