/******************************************************************************
 * mod_uploader / FileWriter.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: FileWriter.h 733 2005-09-24 20:00:54Z svn $
 *****************************************************************************/

#ifndef FILE_WRITER_H
#define FILE_WRITER_H

#include "apr_file_io.h"

#include <cstdlib>

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

using namespace std;
/**
 * @brief եإǡ񤭽Ф饹
 */
class FileWriter
{
public:
    /**
     * 󥹥ȥ饯
     *
     * @param[in] pool ס
     * @param[in] fd եϥɥ
     */
    FileWriter(apr_pool_t *pool, apr_file_t *fd);
    /**
     * եؤν񤭽ФԤޤ
     *
     * @param[in] buf 񤭽Фǡ
     * @param[in] size 񤭽Ф
     * @exception const char * 񤭽Ф˼Ԥ
     */
    virtual void write(const void *buf, apr_size_t size) = 0;
    /**
     * եĤޤ
     *
     * @exception const char * ĤΤ˼Ԥ
     */
    virtual void close();
    /**
     * ǥȥ饯
     *
     * եĤޤ
     */
    virtual ~FileWriter();
protected:
    apr_pool_t *get_pool()
    {
        return pool_;
    }

    apr_file_t *get_fd()
    {
        return fd_;
    }

private:
    FileWriter(const FileWriter &);
    FileWriter &operator=(const FileWriter &);

    /** ס */
    apr_pool_t *pool_;
    /** եϥɥ */
    apr_file_t *fd_;
    /** ˥ե뤬 close 줿ɤ */
    bool is_closed_;
};

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
