/******************************************************************************
 * mod_uploader / lighttpdPostReader.cpp
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: LighttpdPostReader.h 901 2005-10-26 19:32:10Z svn $
 *****************************************************************************/

#ifndef LIGHTTPD_POST_READER_H
#define LIGHTTPD_POST_READER_H

#undef PACKAGE_BUGREPORT
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION
extern "C" {
#include "chunk.h"
}
#undef PACKAGE_BUGREPORT
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION

#include "PostReader.h"

#include <cstdlib>

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

using namespace std;

/**
 * @brief lighttpd  POST ꥯȤɤ߹९饹
 */
class lighttpdPostReader : public PostReader
{
public:
    /**
     * 󥹥ȥ饯Ǥ
     *
     * @param[in] progress Ľ֥
     * @param[in] queue ꥯȥ塼
     */
    lighttpdPostReader(progress *progress, chunkqueue *queue);
    /**
     * POST ꥯȤɤ߹ߤޤ
     *
     * @param[in] buffer ɤ߹ǡ񤭹Хåե
     * @param[in] size ɤ߹ॵ
     * @param[out] read_size ºݤɤ߹
     */
    void read(char *buffer, apr_size_t size, apr_size_t *read_size);

private:
    /**
     * ե mmap ޤ
     *
     * @exception const char * ե mmap ˼Ԥ
     */
    void map_file(chunk *chunk);

    /** ꥯȥ塼 */
    chunkqueue *queue_;
};

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
