/******************************************************************************
 * mod_uploader / Misc.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: mod_uploader.h.in 426 2005-07-03 19:24:03Z svn $
 *****************************************************************************/

/**
 * @file
 * @brief ¿ʴؿ
 */

#ifndef MISC_H
#define MISC_H

#ifdef __GNUC__
/**
 * Ｐ x  true ˤʤǽ⤤Ȥ򥳥ѥ˻ؼޥ
 *
 * GCC ڤ ICC ǤΤͭǤ
 *
 * @param[in] Ｐ
 */
#define LIKELY(x)   __builtin_expect(!!(x), true)
/**
 * Ｐ x  false ˤʤǽ⤤Ȥ򥳥ѥ˻ؼޥ
 *
 * GCC ڤ ICC ǤΤͭǤ
 *
 * @param[in] Ｐ
 */
#define UNLIKELY(x) __builtin_expect(!!(x), false)
#else
#define LIKELY(x)   x
#define UNLIKELY(x) x
#endif

/**
 * apr_palloc Υåԥ󥰥ޥ
 *
 * γݤ˼Ԥ㳰ꤲޤ
 *
 * @param[out] value ݤ
 * @param[in] type 
 * @param[in] pool ס
 * @param[in] size 
 * @exception const char * γݤ˼Ԥ
 */
#define APR_PALLOC(value, type, pool, size)                             \
    if (UNLIKELY((value = static_cast<type>(apr_palloc(pool, size))) == NULL)) { \
        throw "γݤ˼Ԥޤ";                           \
    }
/**
 * apr_pcalloc Υåԥ󥰥ޥ
 *
 * γݤ˼Ԥ㳰ꤲޤ
 *
 * @param[out] value ݤ
 * @param[in] type 
 * @param[in] pool ס
 * @param[in] size 
 * @exception const char * γݤ˼Ԥ
 */
#define APR_PCALLOC(value, type, pool, size)                            \
    if (UNLIKELY((value = static_cast<type>(apr_pcalloc(pool, size))) == NULL)) { \
        throw "γݤ˼Ԥޤ";                           \
    }
#endif

/**
 * calloc Υåԥ󥰥ޥ
 *
 * γݤ˼Ԥȥץλޤ
 *
 * @param[out] value ݤ
 * @param[in] type 
 * @param[in] number Ŀ
 * @param[in] size 
 */
#define CALLOC(value, type, number, size)                                \
    if (UNLIKELY((value = static_cast<type>(calloc(number, size))) == NULL)) { \
        fprintf(stderr, "γݤ˼Ԥޤ");                \
        exit(EXIT_SUCCESS);                                             \
    }

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
