/******************************************************************************
 * mod_uploader / RFC1867Parser.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not bcktuired.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: RFC1867Parser.h 837 2005-10-10 11:18:34Z svn $
 *****************************************************************************/

#ifndef RFC1867_PARSER_H
#define RFC1867_PARSER_H

#include "BinString.h"
#include "RFC1867Data.h"

#include "apr_pools.h"
#include "apr_file_io.h"

#include <cstdlib>

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

using namespace std;

/**
 * @brief RFC1867 Ϥѡ륯饹
 */
template<class FileWriterClass, class PostReaderClass>
class RFC1867Parser
{
public:
    /**
     * 󥹥ȥ饯Ǥ
     *
     * @param[in] file_dir եǥ쥯ȥ
     * @param[in] max_text_size ƥȤκ祵
     * @param[in] max_file_size եκ祵
     * @param[in] max_item_num ޥѡȤΤκĿ
     * @param[in] file_offset ե񤭹ݤΥեå
     * @exception const char * is_strict  true λǡեκ˼Ԥ
     */
    RFC1867Parser(const char *file_dir,
                  apr_size_t max_text_size, apr_size_t max_file_size,
                  apr_size_t max_item_num, apr_size_t file_offset=0);
    /**
     * ޥѡȤɤ߹ߤޤ
     *
     * @param[in] pool ס
     * @param[in] reader POST ꥯȤɤ߹४֥
     * @param[in] content_type Content-Type
     * @param[in] content_size Content-Length
     * @exception const char * Ϥä
     */
    RFC1867Data::query_map *parse(apr_pool_t *pool, PostReaderClass& reader,
                                  const char *content_type, apr_size_t content_size);
    /**
     * ޥѡȤ˴ޤޤƤեбեޤ
     *
     * @param[in] pool ס
     * @param[in] qmap ޥѡȤ
     * @param[in] is_strict ˼Ԥ㳰ꤲ뤫ɤ
     * @exception const char * is_strict  true λǡեκ˼Ԥ
     */
    static void clean_tmp_file(apr_pool_t *pool, RFC1867Data::query_map *qmap,
                               bool is_strict=false);
#ifdef DEBUG
    /**
     * ޥѡȤƤƥȷɸϤɽޤ
     *
     * @param[in] qmap ޥѡȤ
     */
    static void dump_map(RFC1867Data::query_map *qmap);
#endif

private:
    typedef RFC1867Data::query_map query_map;
    typedef RFC1867Data::query_pair query_pair;
    typedef RFC1867Data::rfc1867_content rfc1867_content;
    typedef RFC1867Data::file_content file_content;

    /**
     * ǡɤ߹ñ̡
     *
     * Ϣ³إåΥιפͤ礭ȡɤ߹ߤ
     * Ԥޤ
     */
    static const apr_size_t READ_BLOCK_SIZE;
    /**
     * ǡɤ߹ߤΥॢȻ֡
     *
     * åץɤ줿ե뤬λ֤Ĺʤȡ
     * ץɤ۾ｪλʪȸʤ졤ե뤬ޤ
     *
     * @note ʣեΥåץɤ򰷤Ȥա
     */
    static const apr_size_t READ_TIMEOUT_SEC;
    static const char CR_LF[];
    static const char MULTIPART_FORM_DATA[];
    static const char CONTENT_TYPE[];
    static const char CONTENT_DISP[];
    static const char FORM_DATA[];
    static const char BOUNDARY_PARAM[];
    static const char BOUNDARY_PREFIX[];
    static const char ASSIGN;
    static const char QUOTE;
    static const char DELIMITER;
    static const char NAME_PARAM[];
    static const char FILENAME_PARAM[];

    /** ե̾Υƥץ졼 */
    static const char FILE_NAME_TEMPLATE[];
    /** mktemp λԲ */
    static const apr_size_t MKTEMP_RETRY_NUMBER;

    /** ϥϥɥ */
    typedef struct Handle {
        /** ס */
        apr_pool_t * const pool;
        /** POST ꥯȤɤ߹४֥ */
        PostReaderClass reader;
        /** ڤʸ */
        const char * const boundary;
        /** ڤʸĹ */
        const apr_size_t boundary_len;
        /** ޥѡȤ */
        const RFC1867Data::query_map *qmap;
        /** ɤ߹ߥХåե */
        BinString buffer;

        Handle(apr_pool_t *pool, PostReaderClass& reader, const char *boundary,
               RFC1867Data::query_map *query_map)
            : pool(pool),
              reader(reader),
              boundary(boundary),
              boundary_len(strlen(boundary)),
              qmap(query_map),
              buffer(READ_BLOCK_SIZE*3) // 3 ʾ夸ʤȤޤ
        {
            reader.set_block_size(READ_BLOCK_SIZE);
        }
    } handle;

    /**
     * ΥޥѡȤɤ߹ߤޤ
     *
     * @param[in] h ϥϥɥ
     * @param[out] name ޥѡȤ̾
     * @param[out] content ޥѡȤ
     * @retval true ޥѡȤɤ߹᤿
     * @retval false ˺Ǹޤɤ߹ǤꡤʥޥѡȤɤʤä
     * @exception const char * ϤڤƤꡤƤä
     */
    bool get_content(handle& h, string& name, RFC1867Data::rfc1867_content& content);
    /**
     * ƥȥפΥޥѡȤɤ߹ߤޤ
     *
     * @param[in] h ϥϥɥ
     * @exception const char * ϤڤƤꡤƥȤΥ礭
     */
    const char *get_text_content(handle& h);
    /**
     * ե륿פΥޥѡȤɤ߹ߤޤ
     *
     * @param[in] h ϥϥɥ
     * @param[out] file_digest ե MD5 ϥå
     * @param[out] file_size եΥ
     * @return եΥѥ
     * @exception const char * ϤڤƤꡤեΥ礭
     */
    const char *get_file_content(handle& h, const char **file_digest, apr_size_t *file_size);
    /**
     * ХåեΥǡ READ_BLOCK_SIZE ʾˤʤޤǡХ
     * եإǡɤ߹ߤޤ
     *
     * @param[in] h ϥϥɥ
     */
    apr_size_t store_buffer(handle& h);
    /**
     * Хåեإǡɤ߹ߤޤ
     *
     * @param[in] h ϥϥɥ
     * @param[out] buffer ϥХåե
     * @return ɤ߹
     */
    static apr_size_t read(handle& h, char *buffer);
    /**
     * ޥѡȤζڤʸޤ
     *
     * name ˤ롤ʸڤӡ;פɤФޤ
     * NULL ʸޤޤƤưޤ
     *
     * @param[in] pool ס
     * @param[in] content_type Content-Type إå
     * @return ڤʸ
     * @exception const char * ڤʸǤʤä
     */
    static const char *get_boundary(apr_pool_t *pool, const char *content_type);
    /**
     * ηϤϤޤ
     *
     *   - name=value   (value ˤ϶ʸϴޤޤʤ)
     *   - name="value" (value ˤϡ"פϴޤޤʤ)
     *
     * name ˤ롤ʸڤӡ;פɤФޤ
     * NULL ʸޤޤƤưޤ
     *
     * @param[in] pool ס
     * @param[in] input_start ʸ
     * @param[in] input_end ʸνü
     * @param[in] name name
     * @param[out] value value
     * @retval NULL name ǻꤵ줿ʪȰäꡤname ľˡ=פʤ
     * @retval value["] μΰ ϤǤ
     * @exception const char * "פбդʤ
     */
    static const char *get_param(apr_pool_t *pool,
                                 const char *input_start, const char *input_end,
                                 const char *name, const char **value);
    /**
     * ʸʸ pattern ɤФޤ
     *
     * pattern ϤƬˤɬפޤ NULL ʸ
     * ޤƤưޤ
     *
     * @param[in] pool ס
     * @param[in] input_start ʸ
     * @param[in] pattern ɤФʸ
     * @param[in] is_must ɬɤФɬפ뤫ɤ
     * @exception const char * is_must  true ˤ⤫餺ʸ pattern ǻϤޤäƤʤ
     */
    static const char *skip(apr_pool_t *pool,
                            const char * const input_start,
                            const char * const pattern,
                            bool is_must=true);


    /**
     * CRLF μΰ֤ޤɤФޤ
     *
     *  NULL ʸޤޤƤưޤ
     *
     * @param[in] pool ס
     * @param[in] input_start ʸ
     * @return CRLF μΰ
     * @exception const char * CRLF 򸫤Ĥʤä
     */
    static const char *skip_line(apr_pool_t *pool,
                                 const char * const input_start);

    /**
     * եޤ
     *
     * @param[in] pool ס
     * @param[in] dir եǥ쥯ȥ
     * @param[in,out] file_path եΥѥ
     * @return եΥϥɥ
     */
    static apr_file_t *create_tmp_file(apr_pool_t *pool,
                                       const char *dir, char **file_path);

    RFC1867Parser(const RFC1867Parser&);
    RFC1867Parser &operator=(const RFC1867Parser&);

    /** եǥ쥯ȥ */
    const char * const file_dir_;
    /** ƥȤκ祵 */
    const apr_size_t max_text_size_;
    /** եκ祵 */
    const apr_size_t max_file_size_;
    /** ޥѡȤΤκĿ */
    const apr_size_t max_item_num_;
    /** ե񤭹ݤΥեå */
    const apr_size_t file_offset_;
};

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
