/******************************************************************************
 * mod_uploader / TemplateVariable.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: TemplateExecutor.h 743 2005-09-25 06:11:40Z svn $
 *****************************************************************************/

#ifndef TEMPLATE_VARIABLE_H
#define TEMPLATE_VARIABLE_H

#include "TemplateParser.h"

#include "apr_pools.h"
#include "apr_hash.h"
#include "apr_tables.h"

#include <vector>
#include <map>

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

using namespace std;

/**
 * @brief ƥץ졼Ȥ¹Ԥ륯饹
 */
class TemplateVariable
{
public:
    struct Variable;
    typedef vector<struct Variable *>       variable_map;
    typedef TemplateParser::ident_map       ident_map;

    enum variable_type {
        /**  */
        SCALAR,
        /**  */
        ARRAY,
        /** ϥå */
        HASH
    };

    enum scalar_type {
        /** ʸ */
        STRING,
        /**  */
        INTEGER
    };

    typedef struct Scalar {
        scalar_type type;
        union {
            int i_val;
            const char *s_val;
        };
    } scalar;

    typedef struct Variable {
        variable_type type;
        union {
            apr_array_header_t *a_val;
            apr_hash_t *h_val;
            scalar *s_val;
        };
    } variable;
};

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
