/******************************************************************************
 * mod_uploader / ThumbnailWriter.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: ThumbnailWriter.h 826 2005-10-08 23:02:18Z svn $
 *****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

#ifdef MAKE_THUMBNAIL
#ifndef THUMBNAIL_WRITER_H
#define THUMBNAIL_WRITER_H

#include "UploadItemReader.h"

#include "apr_pools.h"

#include <list>

#if defined(HAVE_FFMPEG_AVCODEC_H) && defined(HAVE_FFMPEG_AVFORMAT_H) && \
    defined(HAVE_FFMPEG_AVIO_H)
#define HAVE_FFMPEG
#if defined(HAVE_SYS_TYPES_H) && defined(HAVE_SYS_WAIT_H) && \
    defined(HAVE_UNISTD_H)
#define SEGV_SAFE
#endif
#endif

#ifdef HAVE_FFMPEG
#include <ffmpeg/avformat.h>
#endif

using namespace std;

namespace Magick {
    class Image;
    class Geometry;
}

/**
 * @brief Υͥ륯饹
 */
class ThumbnailWriter
{
public:
    /**
     * ͥγĥ
     *
     * ͥηϤǻꤹĥҤ˴ŤƷꤵޤ
     */
    static const char FILE_SUFFIX[];

    /**
     * 󥹥ȥ饯Ǥ
     *
     * @param[in] pool ס
     * @param[in] file_dir оݤȤʤե뤬äƤǥ쥯ȥ
     * @param[in] thumb_dir ͥǥ쥯ȥ
     */
    ThumbnailWriter(apr_pool_t *pool,
                    const char *file_dir, const char *thumb_dir);
    /**
     * ϥեΥͥޤ
     *
     * @param[in] file_name ϥե̾
     * @retval true ͥǤ
     * @retval false ͥǤʤä
     * @exception ͥ㳰Ū
     */
    bool write(const char *file_name);

    /**
     * ͥΥѥ֤ޤ
     *
     * @param[in] pool ס
     * @param[in] thumb_dir ͥǥ쥯ȥ
     * @param[in] file_path ϥեΥѥ
     * @return ͥΥѥ
     */
    static const char *create_thumb_path(apr_pool_t *pool,
                                         const char *thumb_dir,
                                         const char *file_path);

private:
    /**
     * ImageMagick ǥͥե륵
     *
     * Թ ImageMagick ؤΥեϤϥǹԤɬ
     * פޤϥեΥ¤ߤ뤳Ȥǡʥ
     * ݤʤ褦ˤƤޤ
     */
    static const apr_size_t MAGICK_SIZE_LIMIT;
    /** ͥκ粣 */
    static const apr_size_t WIDTH_LIMIT;
    /** ͥκĥ */
    static const apr_size_t HEIGHT_LIMIT;
    /** ϤΥХåե */
    static const apr_size_t BUFFER_SIZE;
    /** ư襵ͥݤΥץ󥰴ֳ */
    static const double FRAME_SAMPLE_SEC;
    /** ư襵ͥΥե졼ֳ */
    static const double FRAME_DELAY_SEC;
    /** ư襵ͥΥե졼 */
    static const apr_size_t FRAME_NUMBER;
#ifdef HAVE_FFMPEG
    /** ffmpeg  ImageMagick ǥǡȤꤹݤΥեޥå */
    static const PixelFormat FRAME_PIXEL_FORMAT;
#endif

    /**
     * GIF Υͥޤ
     *
     * @param[in] pool ס
     * @param[in] file_name ϥե̾
     * @retval true ͥǤ
     * @retval false ͥǤʤä
     * @exception const char * ͥ㳰Ū
     */
    bool create_image_thumb(apr_pool_t *pool, const char *file_name);
    bool open_image_file(apr_pool_t *pool, const char *file_name,
                         void **file_buffer, apr_size_t *size);

#ifdef HAVE_FFMPEG
#ifdef SEGV_SAFE
    /**
     * ư GIF Υͥޤ
     *
     * ffmpeg μ¹ԤҥץǹԤȤˤꡤffmpeg 
     * Segmentation fault ȯн褷Ƥޤ
     *
     * @param[in] pool ס
     * @param[in] file_name ϥե̾
     * @retval true ͥǤ
     * @retval false ͥǤʤä
     * @exception const char * ͥ㳰Ū
     *
     * @note åѤƱץ⤫ƱˤδؿƤӽФͤˤʤޤ
     */
    bool create_movie_thumb_safe(apr_pool_t *pool, const char *file_name);
#endif
    /**
     * ư GIF Υͥޤ
     *
     * @param[in] pool ס
     * @param[in] file_name ϥե̾
     * @retval true ͥǤ
     * @retval false ͥǤʤä
     * @exception const char * ͥ㳰Ū
     */
    bool create_movie_thumb(apr_pool_t *pool, const char *file_name);
    /**
     * ϥեưȸʤƳޤ
     *
     * ϥե뤬ưǤʤäꡤбƤʤä
     * false ֤ޤξ硤format_context ͤǤ
     *
     * @param[in] pool ס
     * @param[in] file_path ϥեΥѥ
     * @param[in] format_context
     * @retval true ưɤ߹᤿硥
     * @retval false ưɤ߹ʤä硥
     */
    bool open_movie_file(apr_pool_t *pool, const char *file_path,
                         AVFormatContext **format_context);
    bool open_movie_context(apr_pool_t *pool, const char *file_path,
                            AVFormatContext **format_context,
                            AVCodecContext **codec_context, AVCodec **codec,
                            int *video_index);
    void close_movie_context(AVFormatContext *format_context, AVCodecContext *codec_context);

    /**
     * ư褫ֳ֤ǥե졼ȴФơ˥ͥ
     * ޤ
     *
     * @param[in] format_context
     * @param[in] codec_context
     * @param[in] frame
     * @param[in] picture
     * @param[in] video_index
     * @param[in] frame_sample ץ󥰴ֳ
     * @param[in] frame_delay ͥΥե졼ֳ
     * @param[in] frame_number ͥΥե졼
     * @param[out] frame_list ե졼ΥͥΥꥹ
     */
    static void read_movie_frames(AVFormatContext *format_context, AVCodecContext *codec_context,
                           AVFrame *frame, AVPicture *picture, int video_index,
                           double frame_sample, double frame_delay,
                           apr_size_t frame_number, list<Magick::Image> &frame_list);
#endif

    /**
     * ϥ WIDTH_LIMIT * HEIGHT_LIMIT ˼ޤ褦˽̾ޤ
     *
     * @param[in,out] size 
     */
    static void adjust_size(Magick::Geometry &size);

    ThumbnailWriter(const ThumbnailWriter&);
    ThumbnailWriter &operator=(const ThumbnailWriter&);

    /** ס */
    apr_pool_t *pool_;
    /** оݤȤʤե뤬äƤǥ쥯ȥ */
    const char * const file_dir_;
    /** ͥǥ쥯ȥ */
    const char * const thumb_dir_;
};

#endif

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
