/******************************************************************************
 * mod_uploader / mod_uploader_apache.h.in
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: mod_uploader_apache.h 870 2005-10-21 06:39:56Z svn $
 *****************************************************************************/

#ifndef MOD_UPLOADER_APACHE_H
#define MOD_UPLOADER_APACHE_H

#include "httpd.h"
#include "http_config.h"

#include "ap_config.h"
#include "apr_strings.h"
#include "apr_global_mutex.h"
#include "apr_shm.h"

#undef PACKAGE_BUGREPORT
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION

#include "mod_uploader_data.h"

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

extern "C" module AP_MODULE_DECLARE_DATA uploader_module;

const char USER_DATA_KEY[]                  = PACKAGE_NAME;
const apr_size_t MAX_ERROR_MESSAGE          = 1024;

typedef struct ServerConfig {
    char *upload_lock_path;
    apr_global_mutex_t *upload_lock;

    char *revision_path;
    apr_shm_t *revision_shm;
    apr_size_t *revision;

    char *poster_list_path;
    apr_shm_t *poster_list_shm;
    poster *poster_list;

    char *progress_list_path;
    apr_shm_t *progress_list_shm;
    pprogress *progress_list;
} sconfig;

// Apache 2.0 ϤξϡAP_NEED_SET_MUTEX_PERMS  define ߤ롥
#ifndef AP_SERVER_MAJORVERSION_NUMBER
#if !defined(OS2) && !defined(WIN32) && !defined(BEOS) && !defined(NETWARE)
#define AP_NEED_SET_MUTEX_PERMS
#endif
#endif

class ApacheUploaderConfig;

ApacheUploaderConfig *get_uconfig(request_rec *r);
sconfig *get_sconfig(request_rec *r);

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
