/******************************************************************************
 * mod_uploader / uploader_func.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: uploader_func.h 914 2005-11-17 15:07:03Z svn $
 *****************************************************************************/

#ifndef UPLOADER_FUNC_H
#define UPLOADER_FUNC_H

#include "mod_uploader_data.h"

#include "UploadItem.h"
#include "UploaderConfig.h"
#include "TemplateVariable.h"
#include "TemplateVariableCreator.h"

#include "apr.h"

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

/** ݻο */
const apr_size_t POSTER_LIST_NUMBER         = 16;
/** ݻĽο */
const apr_size_t PROGRESS_LIST_NUMBER       = 32;

#ifndef DEBUG
/** ƥåץɤޤǤԤ */
const apr_size_t POST_INTERVAL_SEC          = UPLOAD_POST_INTERVAL_SEC;
#else
const apr_size_t POST_INTERVAL_SEC          = 0;
#endif
/** åץɴλ˿Ľݻ */
const apr_size_t PROGRESS_HOLD_SEC          = 30;

const apr_size_t SYSTEM_KEY_NUMBER          = 10;

const char FILE_KEY[]                       = "FILE";
const char FILE_LIST_KEY[]                  = "FILE_LIST";
const char PAGE_NUMBER_KEY[]                = "PAGE_NUMBER";
const char CURRENT_PAGE_KEY[]               = "CURRENT_PAGE";
const char TOTAL_FILE_SIZE_KEY[]            = "TOTAL_FILE_SIZE";
const char TOTAL_FILE_SIZE_LIMIT_KEY[]      = "TOTAL_FILE_SIEZE_LIMIT";
const char TOTAL_FILE_NUMBER_KEY[]          = "TOTAL_FILE_NUMBER";
const char MAX_FILE_SIZE_KEY[]              = "MAX_FILE_SIZE";

const char THUMB_LIST_KEY[]                 = "THUMB_LIST";
const char THUMB_NUMBER_KEY[]               = "THUMB_NUMBER";

const char ERROR_MESSAGE_KEY[]              = "ERROR_MESSAGE";

const char IE_NAME_CODE[]                   = "cp932";
const char FIREFOX_NAME_CODE[]              = "utf-8";

typedef TemplateVariable::variable          variable;
typedef TemplateVariable::scalar            scalar;
typedef TemplateVariable::variable_map      variable_map;

const char *safe_getenv(const char *key);
apr_size_t get_page(const char *query);
apr_size_t get_upload_id(const char *query);
const char *get_name_encoding(const char *user_agent);
const char *get_token(apr_pool_t *pool, const char **str, const char delimiter);
bool is_modified_since(apr_pool_t *pool, const char *str, apr_time_t mtime);
variable *create_variable(TemplateVariableCreator& creator, const char *str);
variable *create_variable(TemplateVariableCreator& creator, int i);

variable_map *get_view_vmap(apr_pool_t *pool, UploaderConfig *config,
                            page_template *tmpl, apr_size_t page);
variable_map *get_progress_vmap(apr_pool_t *pool, UploaderConfig *config,
                                page_template *tmpl);
variable_map *get_download_vmap(apr_pool_t *pool, UploaderConfig *config,
                                page_template *tmpl, UploadItem::header *header);
#ifdef MAKE_THUMBNAIL
variable_map *get_thumb_vmap(apr_pool_t *pool, UploaderConfig *config,
                             page_template *tmpl, apr_size_t page);
#endif
variable_map *get_error_vmap(apr_pool_t *pool, UploaderConfig *config,
                             page_template *tmpl, const char *error);

/**
 * ID б륢åץɤοĽ֤ޤ
 *
 * @param[in] progress_list ĽΥꥹ
 * @param[in] upload_id åץ ID
 * @return Ľ
 */
pprogress *get_progress(pprogress *progress_list, apr_size_t upload_id);
/**
 * åץɤοĽϿޤ
 *
 * ̵ϿǤʤäϡget_progress_list Ʊ֤ͤ
 * 
 *
 * @param[in] progress_list ĽΥꥹ
 * @param[in] upload_id åץ ID
 * @param[in] data ¾Υǡ
 * @return ϿĽ
 */
pprogress *add_progress_list(pprogress *progress_list, apr_size_t upload_id,
                             void *data=NULL);

/**
 *  POST_INTERVAL_SEC ô֤ƤԤ줿åޤ
 *
 * @param[in] poster_list Υꥹ
 * @param[in] address ƼԤ IP ɥ쥹
 * @retval true ƤԤ줿
 * @retval false ƤԤƤʤ
 */
bool is_poster_list_contain(poster *poster_list, const char *address);
/**
 * ƻ˴ŤӤޤ
 *
 * @param[in] a 
 * @param[in] b 
 * @retval true a  b ⿷
 * @retval false a  b Ť
 */
int poster_compare(const poster *a, const poster *b);
/**
 * ƾϿޤ
 *
 * @param[in] poster_list Υꥹ
 * @param[in] address ƼԤ IP ɥ쥹
 */
void add_poster_list(poster *poster_list, const char *address);

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
