/******************************************************************************
 * mod_uploader / CGIUploaderConfig.cpp
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: CGIUploaderConfig.cpp 895 2005-10-23 18:50:50Z svn $
 *****************************************************************************/

#include "CGIUploaderConfig.h"
#include "ConfigReader.h"
#include "Misc.h"

#include "apr_strings.h"

#undef DELETE
#define DELETE(ptr) if (ptr != NULL) { delete ptr; ptr = NULL;}
#define DESTROY(pool) if (pool != NULL) { apr_pool_destroy(pool); pool = NULL;}

#ifdef DEBUG
#include <iostream>
#endif

const char CGIUploaderConfig::URL_PARAM[]                       = "url";
const char CGIUploaderConfig::FILE_DIRECTORY_PARAM[]            = "file-directory";
const char CGIUploaderConfig::THUMB_DIRECTORY_PARAM[]           = "thumb-directory";
const char CGIUploaderConfig::TMP_DIRECTORY_PARAM[]             = "tmp-directory";
const char CGIUploaderConfig::VIEW_TEMPLATE_FILE_PARAM[]        = "view-template-file";
const char CGIUploaderConfig::PROGRESS_TEMPLATE_FILE_PARAM[]    = "progress-template-file";
const char CGIUploaderConfig::DOWNLOAD_TEMPLATE_FILE_PARAM[]    = "download-template-file";
const char CGIUploaderConfig::THUMB_TEMPLATE_FILE_PARAM[]       = "thumb-template-file";
const char CGIUploaderConfig::ERROR_TEMPLATE_FILE_PARAM[]       = "error-template-file";
const char CGIUploaderConfig::MAX_FILE_SIZE_PARAM[]             = "max-file-size";
const char CGIUploaderConfig::TOTAL_FILE_SIZE_LIMIT_PARAM[]     = "total-file-size-limit";
const char CGIUploaderConfig::TOTAL_FILE_NUMBER_LIMIT_PARAM[]   = "total-file-number-limit";
const char CGIUploaderConfig::PER_PAGE_ITEM_NUMBER_PARAM[]      = "per-page-item-number";
const char CGIUploaderConfig::LOCK_FILE_NAME[]                  = ".lock";


/******************************************************************************
 * public ᥽å
 *****************************************************************************/
CGIUploaderConfig::~CGIUploaderConfig()
{
    DELETE(uparser);
}

void CGIUploaderConfig::write_lock()
{
    char *lock_file_path;

#ifdef DEBUG
    if (lock_file_ != NULL) {
        throw "餯ХǤ(1)";
    }
#endif

    if (apr_filepath_merge(&lock_file_path, file_dir, LOCK_FILE_NAME,
                           APR_FILEPATH_NOTABOVEROOT, pool_) != APR_SUCCESS) {
        throw "åե̾ǤޤǤ";
    }

    if (apr_file_open(&lock_file_, lock_file_path,
                      APR_READ|APR_WRITE|APR_CREATE|APR_BINARY|APR_SHARELOCK,
                      APR_OS_DEFAULT, pool_)  != APR_SUCCESS) {
        throw "åե򳫤ޤǤ";
    }

    if (apr_file_lock(lock_file_, APR_FLOCK_EXCLUSIVE) != APR_SUCCESS) {
        throw "åǤޤǤ";
    }
}

void CGIUploaderConfig::write_unlock()
{
#ifdef DEBUG
    if (lock_file_ == NULL) {
        throw "餯ХǤ(2)";
    }
#endif

    if (apr_file_unlock(lock_file_) != APR_SUCCESS) {
        throw "åǤޤǤ";
    }

    apr_file_close(lock_file_);
    lock_file_ = NULL;
}

CGIUploaderConfig *CGIUploaderConfig::load(apr_pool_t *pool,
                                           const char *config_path)
{
    CGIUploaderConfig *config;
    auto_ptr<ConfigReader::config_map> cmap(ConfigReader::read(pool, config_path));

    config = new CGIUploaderConfig();

    ConfigReader::config_map::const_iterator i = cmap->begin();
    while (i != cmap->end()) {
        if (strcmp(i->first.c_str(), URL_PARAM) == 0) {
            config->url = apr_pstrdup(pool, i->second.c_str());
        } else if (strcmp(i->first.c_str(), FILE_DIRECTORY_PARAM) == 0) {
            config->file_dir = apr_pstrdup(pool, i->second.c_str());
        } else if (strcmp(i->first.c_str(), THUMB_DIRECTORY_PARAM) == 0) {
            config->thumb_dir = apr_pstrdup(pool, i->second.c_str());
        } else if (strcmp(i->first.c_str(), TMP_DIRECTORY_PARAM) == 0) {
            config->tmp_dir = apr_pstrdup(pool, i->second.c_str());
        } else if (strcmp(i->first.c_str(), VIEW_TEMPLATE_FILE_PARAM) == 0) {
            config->view_tmpl_path = apr_pstrdup(pool, i->second.c_str());
        } else if (strcmp(i->first.c_str(), PROGRESS_TEMPLATE_FILE_PARAM) == 0) {
            config->progress_tmpl_path = apr_pstrdup(pool, i->second.c_str());
        } else if (strcmp(i->first.c_str(), DOWNLOAD_TEMPLATE_FILE_PARAM) == 0) {
            config->download_tmpl_path = apr_pstrdup(pool, i->second.c_str());
        } else if (strcmp(i->first.c_str(), THUMB_TEMPLATE_FILE_PARAM) == 0) {
            config->thumb_tmpl_path = apr_pstrdup(pool, i->second.c_str());
        } else if (strcmp(i->first.c_str(), ERROR_TEMPLATE_FILE_PARAM) == 0) {
            config->error_tmpl_path = apr_pstrdup(pool, i->second.c_str());
        } else if (strcmp(i->first.c_str(), MAX_FILE_SIZE_PARAM) == 0) {
            config->max_file_size = atoi(i->second.c_str()) * 1024;
        } else if (strcmp(i->first.c_str(), TOTAL_FILE_SIZE_LIMIT_PARAM) == 0) {
            config->total_file_size_limit = apr_atoi64(i->second.c_str()) * 1024;
        } else if (strcmp(i->first.c_str(), TOTAL_FILE_NUMBER_LIMIT_PARAM) == 0) {
            config->total_file_number_limit = atoi(i->second.c_str());
        } else if (strcmp(i->first.c_str(), PER_PAGE_ITEM_NUMBER_PARAM) == 0) {
            config->per_page_item_number = atoi(i->second.c_str());
        } else {
            throw "̤ΤܤĤޤ";
        }

        i++;
    }

    config->init(pool);

    return config;
}


/******************************************************************************
 * private ᥽å
 *****************************************************************************/
CGIUploaderConfig::CGIUploaderConfig()
    : UploaderConfig(),
      uparser(NULL),
      lock_file_(NULL)
{

}

void CGIUploaderConfig::init(apr_pool_t *pool)
{
    pool_ = pool;

    validate();
    load_list(0);
    init_template();

    uparser     = new CGIRFC1867Parser(tmp_dir, MAX_FORM_TEXT_SIZE,
                                       max_file_size, MAX_FORM_ITEM_NUMBER,
                                       sizeof(UploadItem::header));

    is_init_ = true;
}

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
