/******************************************************************************
 * mod_uploader / lighttpdPostReader.cpp
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: LighttpdPostReader.cpp 908 2005-10-27 09:56:29Z svn $
 *****************************************************************************/

#include "LighttpdPostReader.h"
#include "PostReader.h"
#include "Misc.h"

#define APR_WANT_MEMFUNC
#include "apr_want.h"

#include <sys/mman.h>
#include <fcntl.h>

#include <algorithm>

#ifdef DEBUG
#include <iostream>
#endif


/******************************************************************************
 * public ᥽å
 *****************************************************************************/
lighttpdPostReader::lighttpdPostReader(progress *progress, chunkqueue *queue)
    : PostReader(progress),
      queue_(queue)
{

}

void lighttpdPostReader::read(char *buffer, apr_size_t size, apr_size_t *read_size)
{
    chunk *chunk;
    apr_size_t chunk_size;

    *read_size = 0;

    if (queue_->bytes_out == queue_->bytes_in) {
        return;
    }

    for (chunk = queue_->first; chunk != NULL; chunk = queue_->first) {
        if (*read_size == size) {
            break;
        }

        switch(chunk->type) {
        case chunk::FILE_CHUNK:
            if (chunk->file.mmap.start == MAP_FAILED) {
                map_file(chunk);
            }

            chunk_size = min(chunk->file.length - chunk->offset,
                             static_cast<long int>(size - *read_size));
            memcpy(buffer, chunk->file.mmap.start + chunk->offset, chunk_size);
            buffer += chunk_size;

            break;
        case chunk::MEM_CHUNK:
            chunk_size = min(chunk->mem->used - chunk->offset - 1,
                             static_cast<unsigned long int>(size - *read_size));
            memcpy(buffer, chunk->mem->ptr + chunk->offset, chunk_size);
            buffer += chunk_size;

            break;
        default:
            throw "̤бηϤǤ";
        }

        if (chunk_size == 0) {
            return;
        }

        *read_size += chunk_size;

        chunk->offset += chunk_size;
        queue_->bytes_out += chunk_size;

        chunkqueue_remove_finished_chunks(queue_);
    }
}


/******************************************************************************
 * private ᥽å
 *****************************************************************************/
void lighttpdPostReader::map_file(chunk *chunk)
{
    if ((chunk->file.fd == -1) &&
        ((chunk->file.fd = open(chunk->file.name->ptr, O_RDONLY)) == -1)) {
        throw "ꥯȤɤ߹ߤ˼Ԥޤ(1)";
    }

    chunk->file.mmap.length = chunk->file.length;
    chunk->file.mmap.start = static_cast<char *>(mmap(0, chunk->file.mmap.length,
                                                      PROT_READ, MAP_SHARED,
                                                      chunk->file.fd, 0));

    if (chunk->file.mmap.start == MAP_FAILED) {
        throw "ꥯȤɤ߹ߤ˼Ԥޤ(2)";
    }

    close(chunk->file.fd);
    chunk->file.fd = -1;
}

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
