/******************************************************************************
 * mod_uploader / mod_uploader_cgi.cpp
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: mod_uploader_cgi.cpp 911 2005-10-27 12:47:05Z svn $
 *****************************************************************************/

/**
 * @file
 * @brief CGI Υȥؿ
 */

#include "mod_uploader_cgi.h"
#include "cgi_handler.h"

#include "uploader_func.h"
#include "CGIResponseWriter.h"
#include "TemplateExecutorImpl.h"

#include "apr_pools.h"

#include <stdlib.h>

#include <iostream>

// #define BENCHMARK 10000
#define BENCHMARK 1

using namespace std;


int main(int argc, const char * const *argv)
{
    apr_pool_t *pool;
    apr_pool_t *handler_pool;
    const char *arg;
    uconfig *config;
    int status;

    apr_app_initialize(&argc, &argv, NULL);
    apr_pool_create(&pool, NULL);

    try {
        arg = getenv("PATH_INFO");
        if (arg == NULL) {
            cout << "Location: http://";
            cout << safe_getenv("SERVER_NAME");

            if ((strcmp(safe_getenv("SERVER_PORT"), "80") != 0)) {
                cout << ":" << safe_getenv("SERVER_PORT");
            }

            cout << safe_getenv("SCRIPT_NAME") << "/\r\n\r\n";
            return EXIT_SUCCESS;
        }


        config = CGIUploaderConfig::load(pool, CONFIG_FILE_NAME);

        for (int i = 0; i < BENCHMARK; ++i) {
            apr_pool_create(&handler_pool, NULL);
            status = command_handler(handler_pool, config, arg+1);
            apr_pool_destroy(handler_pool);
        }

        delete config;

        apr_terminate();

        return status;
    } catch(const char *message) {
        // Ǥ Internal Server Error ˤɡ䤤碌¿
        // ʤꤽʤΤ...
        cout << "Content-type: text/html\r\n\r\n";
        cout << "<!--  -->" << endl;
        cout << "Fatal Error: " << message << endl;

        apr_terminate();

        return EXIT_FAILURE;
    }
}

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
