/******************************************************************************
 * mod_uploader / MmapFileWriter.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: MmapFileWriter.h 1003 2006-03-14 13:52:47Z svn $
 *****************************************************************************/

#ifndef MMAP_FILE_WRITER_H
#define MMAP_FILE_WRITER_H

#include "FileWriter.h"

#include "apr_mmap.h"
#include "apr_pools.h"

#include <cstdlib>

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

using namespace std;

/**
 * @brief mmap Ȥäơեإǡ񤭽Ф饹
 */
class MmapFileWriter: public FileWriter
{
public:
    /**
     * 󥹥ȥ饯
     *
     * offset ꤵƤϡΰְʹߤ˽񤭽ФԤޤ
     *
     * @param[in] pool ס
     * @param[in] fd եϥɥ
     * @param[in] offset 񤭽Ф򳫻Ϥ
     */
    MmapFileWriter(apr_pool_t *pool, apr_file_t *fd, apr_size_t offset=0);
    /**
     * եؤν񤭽ФԤޤ
     *
     * @param[in] buf 񤭽Фǡ
     * @param[in] size 񤭽Ф
     * @exception const char * 񤭽Ф˼Ԥ
     */
    void write(const void *buf, apr_size_t size);
    /**
     * եĤޤ
     *
     * @exception const char * ĤΤ˼Ԥ
     */
    void close();
    /**
     * ǥȥ饯
     *
     * եĤޤ
     */
    ~MmapFileWriter();

private:
    /**
     * mmap ˤƤΥ֥å
     *
     * Ǥϡ٤ write 륵 BLOCK_SIZE 
     * ꤷƤޤ
     */
    static const apr_size_t BLOCK_SIZE;
    /**
     * OS Υڡ
     *
     * getpagesize(2) ȤФͤѤ롥
     */
    static const apr_size_t PAGE_SIZE;

    /**
     * ߤΥޥåԥ󥰤ơΥ֥å֤ޥåפޤ
     */
    void expand();

    MmapFileWriter(const MmapFileWriter&);
    MmapFileWriter &operator=(const MmapFileWriter&);

    /** mmap ξ */
    apr_mmap_t *file_map_;
    /** ߥޥåפƤ֥åΥǥå */
    apr_uint64_t offset_factor_;
    /** mmap ˤƤΥ֥å */
    const apr_size_t block_size_;
    /** ˽񤭹֥åΰ */
    apr_size_t block_offset_;
    /** ˥ե뤬 close 줿ɤ */
    bool is_closed_;
};

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
