/******************************************************************************
 * mod_uploader / TemplateVariableCreator.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: TemplateVariableCreator.h 1003 2006-03-14 13:52:47Z svn $
 *****************************************************************************/

#ifndef TEMPLATE_VARIABLE_CREATOR_H
#define TEMPLATE_VARIABLE_CREATOR_H

#include "TemplateVariable.h"

#include "apr_pools.h"

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

using namespace std;

/**
 * @brief ƥץ졼Ȥѿ륯饹
 */
class TemplateVariableCreator
{
public:
    TemplateVariableCreator(apr_pool_t *pool);
    TemplateVariable::variable *create_variable(TemplateVariable::variable_type type);
    TemplateVariable::scalar *create_scalar(TemplateVariable::scalar_type type);

    static apr_size_t get_ident_id(TemplateVariable::ident_map *imap, const char *name);

private:
    typedef TemplateVariable::ident_map     ident_map;
    typedef TemplateVariable::scalar        scalar;
    typedef TemplateVariable::scalar_type   scalar_type;
    typedef TemplateVariable::variable      variable;
    typedef TemplateVariable::variable_type variable_type;

    static const apr_size_t VARIABLE_POOL_NUM;
    static const apr_size_t SCALAR_POOL_NUM;

    apr_pool_t *pool_;
    variable *variable_pool_;
    variable *variable_pool_end_;
    scalar *scalar_pool_;
    scalar *scalar_pool_end_;
};

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
