/******************************************************************************
 * mod_uploader / UploadItemCreator.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: UploadItemCreator.h 1003 2006-03-14 13:52:47Z svn $
 *****************************************************************************/

#ifndef UPLOADITEMCREATOR_H
#define UPLOADITEMCREATOR_H

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

#include "UploadItem.h"
#include "RFC1867Data.h"

#include "apr_pools.h"

#include <cstdlib>

using namespace std;

/**
 * @brief åץɥƥ륯饹
 */
class UploadItemCreator
{
public:
    static UploadItem::header *create_header(apr_pool_t *pool,
                                             RFC1867Data::query_map *qmap,
                                             const char **file_path);
private:
    typedef RFC1867Data::rfc1867_content content;

    static void validate_query(apr_pool_t *pool, RFC1867Data::query_map *qmap);
    static void validate_file(apr_pool_t *pool, content& content,
                              const unsigned char *code_pat);
    static void validate_comment(apr_pool_t *pool, content& content,
                                 const unsigned char *code_pat);
    static void validate_download_pass(apr_pool_t *pool, content& content);
    static void validate_remove_pass(apr_pool_t *pool, content& content);
    static bool validate_string(const char *str);

    static void convert_code(apr_pool_t *pool, string &str, const unsigned char *code_pat);
    static void escape_html(apr_pool_t *pool, string &str);
    static void set_file_data(apr_pool_t *pool, UploadItem::header *data,
                              RFC1867Data::file_content& file,
                              RFC1867Data::query_map *qmap);

    UploadItemCreator(const UploadItemCreator&);
    UploadItemCreator &operator=(const UploadItemCreator&);
};

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
