/******************************************************************************
 * mod_uploader / UploadItemReader.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: UploadItemReader.h 1003 2006-03-14 13:52:47Z svn $
 *****************************************************************************/

#ifndef UPLOADITEMREADER_H
#define UPLOADITEMREADER_H

#include "UploadItem.h"

#include "apr_pools.h"
#include "apr_file_io.h"

#include <cstdlib>

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

using namespace std;

/**
 * @brief åץɥƥɤ߹ߤԤ饹
 */
class UploadItemReader
{
public:
    UploadItemReader(apr_pool_t *pool, const char *file_dir);
    UploadItem::header *read(const char *file_name, apr_file_t **file,
                             bool is_buffered=true);
    UploadItem::header *read(apr_pool_t *pool, const char *file_name,
                             apr_file_t **file, bool is_buffered=true);

private:
    UploadItemReader(const UploadItemReader&);
    UploadItemReader &operator=(const UploadItemReader&);

    apr_pool_t *pool_;
    const char * const file_dir_;
};

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
