/******************************************************************************
 * mod_uploader / mod_uploader_lighttpd.h.in
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: mod_uploader_lighttpd.h 1003 2006-03-14 13:52:47Z svn $
 *****************************************************************************/

#ifndef MOD_UPLOADER_LIGHTTPD_H
#define MOD_UPLOADER_LIGHTTPD_H

extern "C" {
#include "plugin.h"
}
#undef PACKAGE_BUGREPORT
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION

#include "mod_uploader_data.h"
#include "uploader_func.h"
#include "LighttpdUploaderConfig.h"

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

typedef map<string, uconfig*> uploader_config_map;
typedef pair<string, uconfig*> uploader_config_pair;

/** ץ饰 */
typedef struct PluginConfig {
    unsigned short is_activated;
    buffer *path;
    buffer *url;
    buffer *file_dir;
    buffer *thumb_dir;
    buffer *tmp_dir;
    buffer *view_tmpl_path;
    buffer *progress_tmpl_path;
    buffer *download_tmpl_path;
    buffer *thumb_tmpl_path;
    buffer *error_tmpl_path;
    buffer *max_file_size;
    buffer *total_file_size_limit;
    buffer *total_file_number_limit;
    buffer *per_page_item_number;
} plugin_config;

/** ץ饰Υǡ */
typedef struct {
    PLUGIN_DATA;

    uploader_config_map *uconfig_map;

    plugin_config **pconfig_storage;
    plugin_config pconfig;

    poster poster_list[POSTER_LIST_NUMBER];
    pprogress progress_list[PROGRESS_LIST_NUMBER];
} plugin_data;

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
