/******************************************************************************
 * mod_uploader / ThumbnailWriter.cpp
 ******************************************************************************
 * Copyright (C) 2004 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not bcktuired.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: ThumbnailWriter.cpp 1008 2006-03-14 20:04:20Z svn $
 *****************************************************************************/

#ifdef _MSC_VER
#pragma warning(disable:4251)
#endif

#include "ThumbnailWriter.h"

#ifdef MAKE_THUMBNAIL
#include "UploadItemReader.h"

#include "apr_mmap.h"
#include "apr_file_io.h"
#include "apr_strings.h"

#undef PACKAGE_BUGREPORT
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION
#include <Magick++.h>
#undef PACKAGE_BUGREPORT
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION

#ifdef DEBUG
#include <iostream>
#endif

const char ThumbnailWriter::FILE_SUFFIX[]               = "." THUMBNAIL_FILE_TYPE;
const apr_size_t ThumbnailWriter::MAGICK_SIZE_LIMIT     = THUMBNAIL_MAGICK_SIZE_LIMIT;
const apr_size_t ThumbnailWriter::WIDTH_LIMIT           = THUMBNAIL_WIDTH_LIMIT;
const apr_size_t ThumbnailWriter::HEIGHT_LIMIT          = THUMBNAIL_HEIGHT_LIMIT;
const apr_size_t ThumbnailWriter::BUFFER_SIZE           = THUMBNAIL_BUFFER_SIZE;
const double ThumbnailWriter::FRAME_SAMPLE_SEC          = THUMBNAIL_FRAME_SAMPLE_SEC;
const double ThumbnailWriter::FRAME_DELAY_SEC           = THUMBNAIL_FRAME_DELAY_SEC;
const apr_size_t ThumbnailWriter::FRAME_NUMBER          = THUMBNAIL_FRAME_NUMBER;


/******************************************************************************
 * public ᥽å
 *****************************************************************************/
ThumbnailWriter::ThumbnailWriter(apr_pool_t *pool, const char *file_dir,
                                 const char *thumb_dir)
    : pool_(pool),
      file_dir_(file_dir),
      thumb_dir_(thumb_dir)
{

}

const char *ThumbnailWriter::create_thumb_path(apr_pool_t *pool,
                                               const char *thumb_dir,
                                               const char *file_path)
{
    return apr_pstrcat(pool,
                       thumb_dir, "/", file_path, FILE_SUFFIX, NULL);
}

ThumbnailWriter::~ThumbnailWriter()
{

}


/******************************************************************************
 * protected ᥽å
 *****************************************************************************/
bool ThumbnailWriter::create_image_thumb(apr_pool_t *pool, const char *file_name)
{
    try {
        apr_size_t read_size;
        void *file_buffer;

        if (!open_image_file(pool, file_name, &file_buffer, &read_size)) {
            return false;
        }

        Magick::Blob data(file_buffer, read_size);
        Magick::Image image(data);
        Magick::Geometry thumb_size = image.size();

        if ((image.size().width() == 0) || (image.size().height() == 0)) {
            return false;
        }

        adjust_size(thumb_size);
        image.scale(thumb_size);

        image.write(create_thumb_path(pool, thumb_dir_, file_name));

        return true;
    } catch(Magick::Exception &e) {
        throw e.what();
    } catch(exception &e) {
        throw e.what();
    } catch(const char *) {
        throw;
    }
}

void ThumbnailWriter::adjust_size(Magick::Geometry &size)
{
    if ((static_cast<double>(size.width())/size.height()) >
        (static_cast<double>(WIDTH_LIMIT)/HEIGHT_LIMIT)) {
        // Ĺξ
        if (size.width() > WIDTH_LIMIT) {
            size.height(size.height()*WIDTH_LIMIT/size.width());
            size.width(WIDTH_LIMIT);
        }
    } else {
        // Ĺξ
        if (size.height() > HEIGHT_LIMIT) {
            size.width(size.width()*HEIGHT_LIMIT/size.height());
            size.height(HEIGHT_LIMIT);
        }
    }
}

/******************************************************************************
 * private ᥽å
 *****************************************************************************/
bool ThumbnailWriter::open_image_file(apr_pool_t *pool, const char *file_name,
                                      void **file_buffer, apr_size_t *size)
{
    UploadItem::header *header;
    apr_file_t *file;
    apr_mmap_t *file_map;

    UploadItemReader reader(pool, file_dir_);

    header = reader.read(file_name, &file, false);
    if (header->file_size > MAGICK_SIZE_LIMIT) {
        return false;
    }

    // MEMO:
    // mmap Υ֥åȤϥڡܿʤȤʤΤǡ
    // Ǥ 0 ˤƤ
    if (apr_mmap_create(&file_map, file, 0,
                        sizeof(UploadItem::header)+static_cast<apr_size_t>(header->file_size), // MEMO: 2GB 
                        APR_MMAP_READ, pool) != APR_SUCCESS) {
        throw "åץɥե mmap ˼Ԥޤ";
    }

    APR_PALLOC(*file_buffer, void *, pool,
               static_cast<apr_size_t>(header->file_size)); // MEMO: 2GB 
    memcpy(*file_buffer,
           reinterpret_cast<apr_byte_t *>(file_map->mm)+sizeof(UploadItem::header),
           static_cast<apr_size_t>(header->file_size)); // MEMO: 2GB 

    if (apr_mmap_delete(file_map) != APR_SUCCESS) {
        throw "åץɥե munmap ˼Ԥޤ";
    }

    apr_file_close(file);
    *size = static_cast<apr_size_t>(header->file_size); // MEMO: 2GB 

    return true;
}

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
