/******************************************************************************
 * mod_uploader / UploadItemStream.cpp
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not bcktuired.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id$
 *****************************************************************************/

#include <windows.h>
#include <vfw.h>

#include "UploadItemStream.h"

#ifdef MOVIE_THUMBNAIL
#include "UploadItem.h"

#ifdef DEBUG
#include <iostream>
#endif


/******************************************************************************
 * public ᥽å
 *****************************************************************************/
UploadItemStream::UploadItemStream(apr_pool_t *pool, apr_file_t *file,
                                   apr_uint64_t file_size)
    : pool_(pool),
      file_(file),
      file_size_(file_size)
{

}

UploadItemStream::~UploadItemStream()
{
    apr_file_close(file_);
}

HRESULT STDMETHODCALLTYPE UploadItemStream::Read(void *buffer, ULONG size,
                                                 ULONG *read_size)
{
    apr_size_t apr_read_size;

    apr_read_size = size;
    if (apr_file_read(file_, buffer, &apr_read_size) != APR_SUCCESS) {
        return E_FAIL;
    }

    *read_size = static_cast<ULONG>(apr_read_size);

    return S_OK;
}

HRESULT STDMETHODCALLTYPE UploadItemStream::Seek(LARGE_INTEGER offset,
                                                 DWORD origin,
                                                 ULARGE_INTEGER *new_position)
{
    apr_seek_where_t where;
    apr_off_t apr_offset;

    switch (origin) {
    case STREAM_SEEK_SET:
        where = APR_SET;
        offset.LowPart += sizeof(UploadItem::header);
        break;
    case STREAM_SEEK_CUR:
        where = APR_CUR;
        break;
    case STREAM_SEEK_END:
        where = APR_END;
        break;
    default:
        return E_INVALIDARG;
    };

    apr_offset = offset.LowPart;

    if (apr_file_seek(file_, where, &apr_offset) != APR_SUCCESS) {
        return E_FAIL;
    }

    if (new_position != NULL) {
        new_position->LowPart
            = static_cast<DWORD>(apr_offset - sizeof(UploadItem::header));
        new_position->HighPart = 0;
    }

    return S_OK;
}

HRESULT STDMETHODCALLTYPE UploadItemStream::Stat(STATSTG *stat,
                                                 DWORD stat_flag)
{
    if ((stat == NULL) || (stat_flag != STATFLAG_NONAME)) {
        return E_INVALIDARG;
    }

    memset(stat, 0, sizeof(STATSTG));

    stat->type = STGTY_STREAM;
    stat->cbSize.LowPart = static_cast<DWORD>(file_size_);

    return S_OK;
}

HRESULT STDMETHODCALLTYPE UploadItemStream::QueryInterface(REFIID ref_id,
                                                           void **object)
{
    return E_NOINTERFACE;
}

ULONG STDMETHODCALLTYPE UploadItemStream::AddRef()
{
    return 0;
}

ULONG STDMETHODCALLTYPE UploadItemStream::Release()
{
    delete this;

    return 0;
}

HRESULT STDMETHODCALLTYPE UploadItemStream::Write(void const *pv, ULONG cb,
                                                  ULONG *pcbWritten)
{
    return E_NOTIMPL;
}

HRESULT STDMETHODCALLTYPE UploadItemStream::SetSize(ULARGE_INTEGER libNewSize)
{
    return E_NOTIMPL;
}

HRESULT STDMETHODCALLTYPE UploadItemStream::CopyTo(IStream *pstm,
                                                   ULARGE_INTEGER cb,
                                                   ULARGE_INTEGER *pcbRead,
                                                   ULARGE_INTEGER *pcbWritten)
{
    return E_NOTIMPL;
}

HRESULT STDMETHODCALLTYPE UploadItemStream::Commit(DWORD grfCommitFlags)
{
    return E_NOTIMPL;
}

HRESULT STDMETHODCALLTYPE UploadItemStream::Revert()
{
    return E_NOTIMPL;
}

HRESULT STDMETHODCALLTYPE UploadItemStream::LockRegion(ULARGE_INTEGER libOffset,
                                                       ULARGE_INTEGER cb,
                                                       DWORD dwLockType)
{
    return E_NOTIMPL;
}

HRESULT STDMETHODCALLTYPE UploadItemStream::UnlockRegion(ULARGE_INTEGER libOffset,
                                                         ULARGE_INTEGER cb,
                                                         DWORD dwLockType)
{
    return E_NOTIMPL;
}

HRESULT STDMETHODCALLTYPE UploadItemStream::Clone(IStream **ppstm)
{
    return E_NOTIMPL;
}

LRESULT CALLBACK uploadItemIOProc(LPMMIOINFO mminfo, UINT message,
                                  LPARAM param1, LPARAM param2)
{
    apr_file_t *file = *(reinterpret_cast<apr_file_t **>(mminfo->adwInfo));
    apr_pool_t *pool = *(reinterpret_cast<apr_pool_t **>(mminfo->adwInfo+2));


    switch (message) {
    case MMIOM_OPEN:
        {
            const char *file_path;
            apr_off_t offset;

            file_path = reinterpret_cast<const char *>(param1);
            apr_pool_create(&pool, NULL);

            *(const_cast<char *>(file_path)+strlen(file_path)-strlen(AVI_DUMMY_EXT)) = '\0';

            if (apr_file_open(&file, file_path, APR_READ|APR_BINARY|APR_BUFFERED,
                              APR_OS_DEFAULT, pool) != APR_SUCCESS) {
                apr_pool_destroy(pool);
                return -1;
            }

            offset = sizeof(UploadItem::header);
            if (apr_file_seek(file, APR_SET, &offset) != APR_SUCCESS) {
                apr_pool_destroy(pool);
                return -1;
            }

            *(reinterpret_cast<apr_file_t **>(mminfo->adwInfo)) = file;
            *(reinterpret_cast<apr_pool_t **>(mminfo->adwInfo+2)) = pool;

            return mminfo->lDiskOffset = 0;
        }
    case MMIOM_CLOSE:
        {
            apr_file_close(file);
            apr_pool_destroy(pool);

            return 0;
        }
    case MMIOM_READ:
        {
            apr_size_t read_size;

            read_size = param2;
            if (apr_file_read(file, reinterpret_cast<void *>(param1),
                              &read_size) != APR_SUCCESS) {
                return -1;
            }

            mminfo->lDiskOffset += static_cast<LONG>(read_size);

            return read_size;
        }
    case MMIOM_SEEK:
        {
            apr_seek_where_t where;
            apr_off_t offset;

            switch (param2) {
            case SEEK_SET:
                where = APR_SET;
                param1 += sizeof(UploadItem::header);
                break;
            case SEEK_CUR:
                where = APR_CUR;
            case SEEK_END:
                where = APR_END;
                break;
            }

            offset = param1;
            if (apr_file_seek(file, where, &offset) != APR_SUCCESS) {
                return -1;
            }

            return mminfo->lDiskOffset = static_cast<LONG>(offset - sizeof(UploadItem::header));
        }
    default:
        return -1;
    }
}
#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
