/******************************************************************************
 * mod_uploader / UploadItemWriter.cpp
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not bcktuired.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: UploadItemWriter.cpp 1003 2006-03-14 13:52:47Z svn $
 *****************************************************************************/

#include "UploadItemWriter.h"
#include "Auxiliary.h"

#include "apr_file_io.h"
#include "apr_strings.h"

#ifdef DEBUG
#include <iostream>
#endif

const char UploadItemWriter::FILE_NAME_TEMPLATE[]               = "%16" APR_INT64_T_FMT ".XXXXXX";


/******************************************************************************
 * public ᥽å
 *****************************************************************************/
UploadItemWriter::UploadItemWriter(apr_pool_t *pool, const char *file_dir)
    : pool_(pool),
      file_dir_(file_dir)
{

}

const char* UploadItemWriter::write(UploadItem::header *header, const char *tmp_path)
{
    const char *file_path;

    file_path = create_file_name(pool_, file_dir_);
    write_date(header, file_path, tmp_path);

    return basename_ex(file_path);
}


/******************************************************************************
 * private ᥽å
 *****************************************************************************/
void UploadItemWriter::write_date(UploadItem::header *header, const char *file_path, const char *tmp_path)
{
    apr_file_t *file;
    apr_size_t size;

    if (apr_file_rename(tmp_path, file_path, pool_) != APR_SUCCESS) {
        throw "åץɥե̾ѹǤޤǤ";
    }

    if (apr_file_open(&file, file_path, APR_WRITE|APR_BINARY|APR_BUFFERED,
                      APR_OS_DEFAULT, pool_) != APR_SUCCESS) {
        throw "åץɥե򳫤ޤǤ";
    }

    if ((apr_file_write_full(file, header, sizeof(UploadItem::header), &size) != APR_SUCCESS) ||
        (size != sizeof(UploadItem::header))) {
        throw "åץɥǡν񤭹ߤ˼Ԥޤ";
    }

    apr_file_close(file);
}

const char *UploadItemWriter::create_file_name(apr_pool_t *pool, const char *file_dir)
{
    char *file_path;
    apr_file_t *file;

    if (apr_filepath_merge(&file_path, file_dir,
                           apr_psprintf(pool, FILE_NAME_TEMPLATE, apr_time_now()),
                           APR_FILEPATH_NOTABOVEROOT, pool) != APR_SUCCESS) {
        throw "åץɥե̾ǤޤǤ";
    }

    if (apr_file_mktemp(&file, file_path,
                        APR_READ|APR_WRITE|APR_CREATE|APR_EXCL|APR_BINARY,
                        pool) != APR_SUCCESS) {
        throw "åץɥեǤޤǤ";
    }
    apr_file_close(file);

    return file_path;
}


/******************************************************************************
 * ƥ
 *****************************************************************************/
#ifdef DEBUG_UploadItemWriter
#include "apr_general.h"

#include "RFC1867ParserImpl.h"
#include "UploadItem.h"
#include "UploadItemCreator.h"

static const apr_size_t  BUFSIZE        = 256;
static const char FILE_DIR[]            = "/tmp";
static const char CONTENT_TYPE_TMPL[]   = "multipart/form-data; boundary=%s";

void usage(const char *prog_name)
{
    cerr << "Usage: " << prog_name << " <INPUT>" << endl;
}

int main(int argc, const char * const *argv)
{
    char content_type[BUFSIZE];
    apr_pool_t *pool;
    apr_file_t *fd;
    apr_off_t offset;
    UploadItem::header *header;
    const char *tmp_path;
    const char *file_path;

    apr_app_initialize(&argc, &argv, NULL);
    apr_pool_create(&pool, NULL);

    try {
        if (argc != 2) {
            throw "ѤΥե뤬ꤵƤޤ";
        }

        if (apr_file_open(&fd, argv[1], APR_READ|APR_BINARY,
                          APR_OS_DEFAULT, pool) != APR_SUCCESS) {
            throw "ѤΥե򳫤ޤǤ";
        }

        if (apr_file_gets(content_type, sizeof(content_type), fd) != APR_SUCCESS) {
            throw "ѤΥե read ˼Ԥޤ";
        }
        offset = 0;
        if (apr_file_seek(fd, APR_SET, &offset) != APR_SUCCESS) {
            throw "ѤΥե seek ˼Ԥޤ";
        }

        UploadParser parser(FILE_DIR, 10*1024*1024, 32*1024*1024, 5,
                            sizeof(UploadItem::header));

        auto_ptr<UploadParser::query_map>
            qmap(parser.parse(pool, fd,
                              apr_psprintf(pool, CONTENT_TYPE_TMPL, content_type+2)));

        UploadItemWriter writer(pool, FILE_DIR);
        header = UploadItemCreator::create_header(pool, qmap.get(), &tmp_path);

        file_path = writer.write(header, tmp_path);

        UploadParser::clean_tmp_file(pool, qmap.get());
        UploadItem::dump_header(header);
    } catch(const char *message) {
        cerr << "Error: " << message << endl;
        usage(argv[0]);

        return EXIT_FAILURE;
    }

    apr_terminate();

    return EXIT_SUCCESS;
}
#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
