/******************************************************************************
 * mod_uploader / WindowsThumbnailWriter.cpp
 ******************************************************************************
 * Copyright (C) 2004 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not bcktuired.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: ThumbnailWriter.cpp 929 2005-12-07 16:22:39Z svn $
 *****************************************************************************/

#pragma warning(disable:4251)

#include <windows.h>
#include <vfw.h>

#include "WindowsThumbnailWriter.h"

#ifdef MAKE_THUMBNAIL
#include "UploadItem.h"
#include "Auxiliary.h"
#include "Misc.h"

#include "apr_file_io.h"
#include "apr_strings.h"

#undef PACKAGE_BUGREPORT
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION
#include <Magick++.h>
#undef PACKAGE_BUGREPORT
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION

#ifdef DEBUG
#include <iostream>
#endif

#ifndef SAFE_RELEASE
#define SAFE_RELEASE(p) { if(p) { (p)->Release(); (p)=NULL; } }
#endif


/******************************************************************************
 * public ᥽å
 *****************************************************************************/
WindowsThumbnailWriter::WindowsThumbnailWriter(apr_pool_t *pool,
                                               const char *file_dir,
                                               const char *thumb_dir)
    : ThumbnailWriter(pool, file_dir, thumb_dir)
{

}

bool WindowsThumbnailWriter::write(const char *file_name)
{
    apr_pool_t *pool;
    bool is_created = false;

    if (apr_pool_create(&pool, pool_) != APR_SUCCESS) {
        throw "γݤ˼Ԥޤ";
    }

    try {
        do {
#ifdef MOVIE_THUMBNAIL
            if (is_created = wmv_create_movie_thumb(pool, file_name)) { // 
                break;
            }
            if (is_created = avi_create_movie_thumb(pool, file_name)) { // 
                break;
            }
#endif
            if (is_created = create_image_thumb(pool, file_name)) { // 
                break;
            }
        } while (false);

        apr_pool_destroy(pool);

        return is_created;
    } catch(const char *) {
        apr_pool_destroy(pool);
        throw;
    }
}


/******************************************************************************
 * private ᥽å
 *****************************************************************************/
#ifdef MOVIE_THUMBNAIL
bool WindowsThumbnailWriter::wmv_create_movie_thumb(apr_pool_t *pool,
                                                    const char *file_name)
{
    list<Magick::Image> frame_list;
    UploadItemStream *item_stream = NULL;
    IWMSyncReader *wmv_reader = NULL;
    WORD stream_number;
    LONG frame_width;
    LONG frame_height;

    CoInitialize(NULL);

    try {
        item_stream = wmv_open_movie_file(pool, file_name);

        wmv_reader = wmv_open_movie(item_stream);

        stream_number = static_cast<WORD>(wmv_get_stream_number(wmv_reader));

        wmv_get_stream_info(wmv_reader, stream_number,
                            &frame_width, &frame_height);

        wmv_select_stream(wmv_reader, stream_number);

        wmv_read_movie_frames(wmv_reader, stream_number,
                              frame_width, frame_height,
                              ThumbnailWriter::FRAME_SAMPLE_SEC,
                              ThumbnailWriter::FRAME_DELAY_SEC,
                              ThumbnailWriter::FRAME_NUMBER,
                              frame_list);

        Magick::writeImages(frame_list.begin(), frame_list.end(),
                            create_thumb_path(pool, thumb_dir_, file_name));

        SAFE_RELEASE(item_stream);
        SAFE_RELEASE(wmv_reader);

        return true;
    } catch(const char *) {
        SAFE_RELEASE(item_stream);
        SAFE_RELEASE(wmv_reader);

        return false;
    }
}

UploadItemStream *WindowsThumbnailWriter::wmv_open_movie_file(apr_pool_t *pool,
                                                              const char *file_name)
{
    char *file_path;
    apr_file_t *file;
    apr_off_t offset;
    apr_finfo_t info;

    if (apr_filepath_merge(&file_path, file_dir_, file_name,
                           APR_FILEPATH_NOTABOVEROOT, pool) != APR_SUCCESS) {
        throw "åץɥե̾ǤޤǤ";
    }

    if (apr_file_open(&file, file_path, APR_READ|APR_BINARY|APR_BUFFERED,
                      APR_OS_DEFAULT, pool) != APR_SUCCESS) {
        throw "ե open ˼Ԥޤ";
    }

    offset = sizeof(UploadItem::header);
    if (apr_file_seek(file, APR_SET, &offset) != APR_SUCCESS) {
        throw "ե seek ˼Ԥޤ";
    }

    if (apr_stat(&info, file_path, APR_FINFO_SIZE, pool) != APR_SUCCESS) {
        throw "ե stat ˼Ԥޤ";
    }

    return new UploadItemStream(pool, file,
                                info.size-sizeof(UploadItem::header));
}

IWMSyncReader *WindowsThumbnailWriter::wmv_open_movie(UploadItemStream *stream)
{
    IWMSyncReader *wmv_reader;

    if (FAILED(WMCreateSyncReader(NULL, 0, &wmv_reader))) {
        throw "WMV ɤ߹ѥ֥Ȥ˼Ԥޤ";
    }

    if (FAILED(wmv_reader->OpenStream(stream))) {
        throw "WMV ɤ߹ߤ˼Ԥޤ(1)";
    }

    return wmv_reader;
}

DWORD WindowsThumbnailWriter::wmv_get_stream_number(IWMSyncReader *wmv_reader)
{
    IWMProfile *wmv_profile = NULL;
    IWMStreamConfig *wmv_stream = NULL;
    DWORD stream_count;
    WORD stream_number;
    GUID stream_type;

    if (FAILED(wmv_reader->QueryInterface(IID_IWMProfile,
                                          reinterpret_cast<VOID **>(&wmv_profile)))) {
        throw "WMV ɤ߹ߤ˼Ԥޤ(2)";
    }

    if (FAILED(wmv_profile->GetStreamCount(&stream_count))) {
        throw "WMV ɤ߹ߤ˼Ԥޤ(3)";
    }

    for (DWORD i = 0; i < stream_count; i++) {
        try {
            if (FAILED(wmv_profile->GetStream(i, &wmv_stream))) {
                throw "WMV ɤ߹ߤ˼Ԥޤ(4)";
            }

            if (FAILED(wmv_stream->GetStreamType(&stream_type))) {
                throw "WMV ɤ߹ߤ˼Ԥޤ(5)";
            }

            if (stream_type != WMMEDIATYPE_Video) {
                continue;
            }

            if (FAILED(wmv_stream->GetStreamNumber(&stream_number))) {
                throw "WMV ɤ߹ߤ˼Ԥޤ(6)";
            }

            SAFE_RELEASE(wmv_profile);
            SAFE_RELEASE(wmv_stream);
        } catch(const char *) {
            SAFE_RELEASE(wmv_profile);
            SAFE_RELEASE(wmv_stream);

            throw;
        }

        return stream_number;
    }

    throw "WMV ˱ޤޤƤޤ";
}

void WindowsThumbnailWriter::wmv_get_stream_info(IWMSyncReader *wmv_reader,
                                                 WORD stream_number,
                                                 LONG *frame_width,
                                                 LONG *frame_height)
{
    BYTE media_type_buffer[512]; // ¿ˤȤäƤ
    DWORD output_number;
    IWMOutputMediaProps *media_props;
    WM_MEDIA_TYPE *media_type;
    DWORD media_type_size;
    WMVIDEOINFOHEADER *video_info;
    BITMAPINFOHEADER bitmap_info;

    if (FAILED(wmv_reader->GetOutputNumberForStream(stream_number,
                                                    &output_number))) {
        throw "WMV ɤ߹ߤ˼Ԥޤ(7)";
    }

    if (FAILED(wmv_reader->GetOutputProps(output_number, &media_props))) {
        throw "WMV ɤ߹ߤ˼Ԥޤ(8)";
    }

    media_type = reinterpret_cast<WM_MEDIA_TYPE *>(media_type_buffer);
    media_type_size = sizeof(media_type_buffer);

    if (FAILED(media_props->GetMediaType(media_type, &media_type_size))) {
        throw "WMV ɤ߹ߤ˼Ԥޤ(9)";
    }

    if (media_type->majortype != WMMEDIATYPE_Video) {
        throw "WMV ɤ߹ߤ˼Ԥޤ(10)"; // ˤϤʤϤ
    }

    if (media_type->subtype != WMMEDIASUBTYPE_RGB24) {
        throw "бƤʤեޥåȤǤ"; // ȤꤢͤƤ
    }

    video_info = reinterpret_cast<WMVIDEOINFOHEADER *>(media_type->pbFormat);
    bitmap_info = video_info->bmiHeader;

    *frame_width = bitmap_info.biWidth;
    *frame_height = bitmap_info.biHeight;
}

void WindowsThumbnailWriter::wmv_select_stream(IWMSyncReader *wmv_reader,
                                               WORD stream_number)
{
    WMT_STREAM_SELECTION stream_selection = WMT_ON;

    if (FAILED(wmv_reader->SetStreamsSelected(1, &stream_number,
                                              &stream_selection))) {
        throw "WMV ɤ߹ߤ˼Ԥޤ(11)";
    }

    if (FAILED(wmv_reader->SetReadStreamSamples(stream_number, false))) {
        throw "WMV ɤ߹ߤ˼Ԥޤ(12)";
    }
}

void WindowsThumbnailWriter::wmv_read_frame_image(IWMSyncReader *wmv_reader,
                                                  WORD stream_number,
                                                  LONG frame_width,
                                                  LONG frame_height,
                                                  Magick::Image& frame_image)
{
    INSSBuffer *stream_buffer = NULL;
    QWORD frame_time = 0;
    QWORD frame_duration = 0;
    DWORD frame_flag = 0;
    BYTE *frame_buffer;

    try {
        if (FAILED(wmv_reader->GetNextSample(stream_number, &stream_buffer, &frame_time,
                                             &frame_duration, &frame_flag,
                                             NULL, NULL))) {
            throw "WMV ɤ߹ߤ˼Ԥޤ(13)";
        }

        if (FAILED(stream_buffer->GetBuffer(&frame_buffer))) {
            throw "WMV ɤ߹ߤ˼Ԥޤ(14)";
        }

        frame_image = Magick::Image(frame_width, frame_height, "BGR",
                                    Magick::CharPixel, frame_buffer);
        frame_image.flip(); // եޥåѴ

        SAFE_RELEASE(stream_buffer);
    } catch(const char *) {
        SAFE_RELEASE(stream_buffer);
        throw;
    }
}

void WindowsThumbnailWriter::wmv_read_movie_frames(IWMSyncReader *wmv_reader,
                                                   WORD stream_number,
                                                   LONG frame_width,
                                                   LONG frame_height,
                                                   double frame_sample,
                                                   double frame_delay,
                                                   apr_size_t frame_number,
                                                   list<Magick::Image> &frame_list)
{
    Magick::Image frame_image;
    Magick::Geometry thumb_size(frame_width, frame_height);

    adjust_size(thumb_size);

    for (apr_size_t i = 0; i < frame_number; i++) {
        try {
            if (FAILED(wmv_reader->SetRange(static_cast<QWORD>((i+1)*frame_sample*1000000),
                                            0))) {
                throw "WMV ɤ߹ߤ˼Ԥޤ(15)";
            }

            wmv_read_frame_image(wmv_reader, stream_number,
                                 frame_width, frame_height, frame_image);

            frame_image.scale(thumb_size);
            frame_image.animationDelay(static_cast<unsigned int>(frame_delay*100));
            frame_image.animationIterations(0);

            frame_list.push_back(frame_image);
        } catch(const char *) {
            // ǽΥե졼ǥ顼äΤ㳰ꤲ
            if (i == 0) {
                throw;
            } else {
                break;
            }
        }
    }
}

bool WindowsThumbnailWriter::avi_create_movie_thumb(apr_pool_t *pool,
                                                    const char *file_name)
{
    list<Magick::Image> frame_list;
    PAVISTREAM stream = NULL;
    PGETFRAME frame = NULL;
    LONG frame_width;
    LONG frame_height;
    bool is_succeed;

    CoInitialize(NULL);

    mmioInstallIOProc(mmioFOURCC(AVI_DUMMY_EXT[1], AVI_DUMMY_EXT[2],
                                 AVI_DUMMY_EXT[3], ' '),
                      (LPMMIOPROC)uploadItemIOProc, MMIO_INSTALLPROC);

    try {
        stream = avi_open_movie(pool, file_name);

        avi_stream_info(stream, &frame_width, &frame_height);

        frame = avi_open_frame(stream);

        avi_read_movie_frames(frame, stream, frame_width, frame_height,
                              ThumbnailWriter::FRAME_SAMPLE_SEC,
                              ThumbnailWriter::FRAME_DELAY_SEC,
                              ThumbnailWriter::FRAME_NUMBER,
                              frame_list);

        Magick::writeImages(frame_list.begin(), frame_list.end(),
                            create_thumb_path(pool, thumb_dir_, file_name));

        is_succeed = true;
    } catch(const char *) {
        is_succeed = false;
    }

    if (frame != NULL) {
        AVIStreamGetFrameClose(frame);
    }
    if (stream != NULL) {
        AVIStreamRelease(stream);
    }

    AVIFileExit();

    return is_succeed;
}

PAVISTREAM WindowsThumbnailWriter::avi_open_movie(apr_pool_t *pool,
                                                  const char *file_name)
{
    char *file_path;
    PAVISTREAM stream;

    file_name = apr_pstrcat(pool, file_name, AVI_DUMMY_EXT, NULL);

    if (apr_filepath_merge(&file_path, file_dir_, file_name,
                           APR_FILEPATH_NOTABOVEROOT, pool) != APR_SUCCESS) {
        throw "åץɥե̾ǤޤǤ";
    }

    if (AVIStreamOpenFromFile(&stream, file_path, streamtypeVIDEO, 0,
                              OF_READ|OF_SHARE_EXCLUSIVE, NULL) != 0) {
        throw "AVI ɤ߹ߤ˼Ԥޤ(1)";
    }

    return stream;
}

PGETFRAME WindowsThumbnailWriter::avi_open_frame(PAVISTREAM stream)
{
    PGETFRAME frame;

    if ((frame = AVIStreamGetFrameOpen(stream, NULL)) == NULL) {
        throw "AVI ɤ߹ߤ˼Ԥޤ(5)";
    }

    return frame;
}

void WindowsThumbnailWriter::avi_stream_info(PAVISTREAM stream,
                                             LONG *frame_width,
                                             LONG *frame_height)
{
    AVISTREAMINFO stream_info;

    if (AVIStreamInfo(stream, &stream_info, sizeof(AVISTREAMINFO)) != 0 ) {
        throw "AVI ɤ߹ߤ˼Ԥޤ(6)";
    }

    *frame_width = stream_info.rcFrame.right;
    *frame_height = stream_info.rcFrame.bottom;
}

void WindowsThumbnailWriter::avi_read_frame_image(PGETFRAME frame,
                                                  LONG frame_index,
                                                  Magick::Image& frame_image)
{
    LPBITMAPINFOHEADER frame_header;

    if ((frame_header
         = reinterpret_cast<LPBITMAPINFOHEADER>(AVIStreamGetFrame(frame,
                                                                  frame_index))) == NULL) {
        throw "AVI ɤ߹ߤ˼Ԥޤ(7)";
    }

    if ((frame_header->biBitCount != 24) ||
        (frame_header->biCompression != 0)) {
        throw "бƤʤեޥåȤǤ"; // ȤꤢͤƤ
    }

    frame_image = Magick::Image(frame_header->biWidth, frame_header->biHeight,
                                "BGR", Magick::CharPixel, frame_header+1);
    frame_image.flip(); // եޥåѴ
}

void WindowsThumbnailWriter::avi_read_movie_frames(PGETFRAME frame,
                                                   PAVISTREAM stream,
                                                   LONG frame_width,
                                                   LONG frame_height,
                                                   double frame_sample,
                                                   double frame_delay,
                                                   apr_size_t frame_number,
                                                   list<Magick::Image> &frame_list)
{
    Magick::Image frame_image;
    LONG frame_index;
    Magick::Geometry thumb_size(frame_width, frame_height);

    adjust_size(thumb_size);

    for (apr_size_t i = 0; i < frame_number; i++) {
        try {
            if ((frame_index = AVIStreamTimeToSample(stream,
                                                     static_cast<LONG>((i+1)*frame_sample*1000))) == -1) {
                throw "AVI ɤ߹ߤ˼Ԥޤ(8)";
            }

            avi_read_frame_image(frame, frame_index, frame_image);

            frame_image.scale(thumb_size);
            frame_image.animationDelay(static_cast<unsigned int>(frame_delay*100));
            frame_image.animationIterations(0);

            frame_list.push_back(frame_image);
        } catch(const char *) {
            if (i == 0) {
                throw;
            } else {
                break;
            }
        }
    }
}
#endif


/******************************************************************************
 * ƥ
 *****************************************************************************/
#ifdef DEBUG_WindowsThumbnailWriter

#include "apr_general.h"
#include "apr_file_io.h"

static const char THUMB_DIR[]            = ".";

void usage(const char *prog_name)
{
    cerr << "Usage: " << prog_name << " <FILE> <MAGICKDIR>" << endl;
}

int main(int argc, const char * const *argv)
{
    apr_pool_t *pool;

    apr_app_initialize(&argc, &argv, NULL);
    apr_pool_create(&pool, NULL);

    try {
        if (argc != 2) {
            throw "ѤΥե뤬ꤵƤޤ";
        }

        WindowsThumbnailWriter writer(pool, dirname_ex(pool, argv[1]), THUMB_DIR);
        writer.write(basename_ex(argv[1]));
    } catch(const char *message) {
        cerr << "Error: " << message << endl;
        usage(argv[0]);

        return EXIT_FAILURE;
    }

    apr_terminate();

    return EXIT_SUCCESS;
}
#endif

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
