/******************************************************************************
 * mod_uploader / BinString.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not bcktuired.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: BinString.h 1003 2006-03-14 13:52:47Z svn $
 *****************************************************************************/

#ifndef BINSTRING_H
#define BINSTRING_H

#include "apr.h"
#define APR_WANT_MEMFUNC
#include "apr_want.h"

#include <cstdlib>

using namespace std;

/**
 * @brief Хʥʸɽ饹
 *
 * RFC1867Parser.cpp ǻȤ뤳Ȥ˺Ƥޤ
 */
class BinString
{
public:
    BinString(apr_size_t size=0);
    ~BinString();
    void reserve(apr_size_t size);

    char *data()
    {
#ifdef DEBUG
        if (buffer_ == NULL) {
            throw "ХåեƤޤ";
        }
#endif
        return buffer_;
    }
    void size(apr_size_t size)
    {
#ifdef DEBUG
        if (size > buf_size_) {
            throw "礭ޤ";
        }
#endif
        size_ = size;
        *(buffer_+size_) = '\0';
    }
    apr_size_t size()
    {
        return size_;
    }
    void erase(apr_size_t size)
    {
#ifdef DEBUG
        if (size > size_) {
            throw "õ륵Ǥ";
        } else if (buffer_ == NULL) {
            throw "Ǥ";
        }
#endif
        if (size == 0) {
            return;
        }

        size_ -= size;
        memmove(buffer_, buffer_+size, size_);
    }

private:
    static const apr_size_t DEFAULT_SIZE;

    BinString(const BinString&);
    BinString &operator=(const BinString&);

    char *buffer_;
    apr_size_t buf_size_;
    apr_size_t size_;

    char *alloc(apr_size_t size);
};

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
