/******************************************************************************
 * mod_uploader / PostReader.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: PostReader.h 1003 2006-03-14 13:52:47Z svn $
 *****************************************************************************/

#ifndef POST_READER_H
#define POST_READER_H

#include "apr.h"
#include "apr_time.h"

#include <cstdlib>

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

using namespace std;

/**
 * @brief POST ꥯȤɤ߹९饹
 */
class PostReader
{
public:
    /**
     * POST ꥯȤοĽ
     */
    typedef struct Progress {
        /** åץ ID */
        apr_uint32_t upload_id;
        /** POST ꥯȤΥȡ륵 */
        apr_uint64_t total_size;
        /** ɤ߹ߺѤߤΤΥȡ륵 */
        apr_uint64_t read_size;
        /** POST ꥯȤδλ */
        apr_time_t end_time;
        /** ¾Υǡ */
        void *data;
    } progress;

    /**
     * 󥹥ȥ饯Ǥ
     *
     * @param[in] progress Ľ֥
     */
    PostReader(progress *progress);
    /**
     * ꥯȤɤ߹ñ̤򥻥åȤޤ
     *
     * @param[in] block_size ꥯȤɤ߹ñ
     */
    void set_block_size(apr_size_t block_size);
    /**
     * POST ꥯȤɤ߹ߤޤ
     *
     * @param[in] buffer ɤ߹ǡ񤭹Хåե
     * @param[in] size ɤ߹ॵ
     * @param[out] read_size ºݤɤ߹
     */
    virtual void read(char *buffer, apr_size_t size, apr_size_t *read_size) = 0;
    virtual ~PostReader();

protected:
    void update(apr_size_t read_size);
    apr_size_t get_block_size();

private:
    /** ꥯȤɤ߹ñ̤Υǥե */
    static const apr_size_t DEFAULT_BLOCK_SIZE;

    /**
     * ꥯȤɤ߹ñ
     *
     * ͤܰ¤Ǥɬǻꤷ read ɬפ
     * ޤ
     */
    apr_size_t block_size_;
    /** Ľ֥ */
    progress *progress_;
};

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
