/******************************************************************************
 * mod_uploader / RssView.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: TemplateExecutor.h 160 2005-03-19 18:17:33Z svn $
 *****************************************************************************/

#ifndef RSS_VIEW_H
#define RSS_VIEW_H

#include "UploadItemList.h"

#include "apr_pools.h"
#include "apr_time.h"

#include <cstdlib>

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

using namespace std;

/**
 * @brief RSS Ϥ륯饹
 */
template<class ResponseWriterClass>
class RssView
{
public:
    /** ڡ Content-type */
    static const char content_type[];

    /**
     * 󥹥ȥ饯Ǥ
     *
     * @param[in] pool ס
     * @param[in] writer 쥹ݥ󥹤񤭽Ф֥ȡ
     */
    RssView(apr_pool_t *pool, ResponseWriterClass& writer);

    /**
     * ڡϤޤ
     *

     * @param[in] base_url ȥåץڡ URL
     * @param[in] per_page_item_number ڡɽ륢ƥ
     * @param[in] item_list åץɥƥΥꥹ
     */
    void exec(const char *base_url, apr_size_t per_page_item_number,
              UploadItemList *item_list);
private:
    /** ɽκĹ */
    static const apr_size_t MAX_TIME_LENGTH;
    /** ɽΥեޥå */
    static const char TIME_FORMAT[];
    /** ॾΥեå͡ʡhh:mm */
    static const apr_size_t TIME_ZONE_OFFSET;

    typedef UploadItemList::item_info item_info;
    /**
     * ϥϥɥ롥
     */
    typedef struct Handle {
        /** ȥåץڡ URL */
        const char * const base_url;

        Handle(const char *base_url)
            : base_url(base_url)
        {

        }
    } handle;

    /**
     * åץɥƥϤޤ
     *
     * @param[in] h ϥϥɥ
     * @param[in] item åץɥƥ
     */
    void print(handle *h, item_info *item);
    /**
     * ʸϤޤ
     *
     * @param[in] h ϥϥɥ
     * @param[in] str ʸ
     */
    void print(handle *h, const char *str);
    /**
     * ʸϤޤ
     *
     * @param[in] pool ס
     * @param[in] time 
     * @return եޥåȤ
     */
    static const char *time_str(apr_pool_t *pool, apr_time_t time);

    RssView(const RssView&);
    RssView &operator=(const RssView&);

    /** ס */
    apr_pool_t *pool_;
    /** 쥹ݥ󥹤񤭽Ф֥ */
    ResponseWriterClass writer_;
};

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
