/******************************************************************************
 * mod_uploader / ThumbnailWriter.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: ThumbnailWriter.h 1003 2006-03-14 13:52:47Z svn $
 *****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

#ifdef MAKE_THUMBNAIL
#ifndef THUMBNAIL_WRITER_H
#define THUMBNAIL_WRITER_H

#include "apr_pools.h"

namespace Magick {
    class Image;
    class Geometry;
}

/**
 * @brief Υͥ륯饹
 */
class ThumbnailWriter
{
public:
    /**
     * ͥγĥ
     *
     * ͥηϤǻꤹĥҤ˴ŤƷꤵޤ
     */
    static const char FILE_SUFFIX[];

    /**
     * 󥹥ȥ饯Ǥ
     *
     * @param[in] pool ס
     * @param[in] file_dir оݤȤʤե뤬äƤǥ쥯ȥ
     * @param[in] thumb_dir ͥǥ쥯ȥ
     */
    ThumbnailWriter(apr_pool_t *pool,
                    const char *file_dir, const char *thumb_dir);

    /**
     * ϥեΥͥޤ
     *
     * @param[in] file_name ϥե̾
     * @retval true ͥǤ
     * @retval false ͥǤʤä
     * @exception ͥ㳰Ū
     */
    virtual bool write(const char *file_name) = 0;

    /**
     * ͥΥѥ֤ޤ
     *
     * @param[in] pool ס
     * @param[in] thumb_dir ͥǥ쥯ȥ
     * @param[in] file_path ϥեΥѥ
     * @return ͥΥѥ
     */
    static const char *create_thumb_path(apr_pool_t *pool,
                                         const char *thumb_dir,
                                         const char *file_path);
    virtual ~ThumbnailWriter();

protected:
    /** ư襵ͥݤΥץ󥰴ֳ */
    static const double FRAME_SAMPLE_SEC;
    /** ư襵ͥΥե졼ֳ */
    static const double FRAME_DELAY_SEC;
    /** ư襵ͥΥե졼 */
    static const apr_size_t FRAME_NUMBER;
    /** ϤΥХåե */
    static const apr_size_t BUFFER_SIZE;

    /**
     * GIF Υͥޤ
     *
     * @param[in] pool ס
     * @param[in] file_name ϥե̾
     * @retval true ͥǤ
     * @retval false ͥǤʤä
     * @exception const char * ͥ㳰Ū
     */
    bool create_image_thumb(apr_pool_t *pool, const char *file_name);

    /**
     * ϥ WIDTH_LIMIT * HEIGHT_LIMIT ˼ޤ褦˽̾ޤ
     *
     * @param[in,out] size 
     */
    static void adjust_size(Magick::Geometry &size);
    /** ס */
    apr_pool_t *pool_;
    /** оݤȤʤե뤬äƤǥ쥯ȥ */
    const char * const file_dir_;
    /** ͥǥ쥯ȥ */
    const char * const thumb_dir_;

private:
    /**
     * ImageMagick ǥͥե륵
     *
     * Թ ImageMagick ؤΥեϤϥǹԤɬ
     * פޤϥեΥ¤ߤ뤳Ȥǡʥ
     * ݤʤ褦ˤƤޤ
     */
    static const apr_size_t MAGICK_SIZE_LIMIT;
    /** ͥκ粣 */
    static const apr_size_t WIDTH_LIMIT;
    /** ͥκĥ */
    static const apr_size_t HEIGHT_LIMIT;

    bool open_image_file(apr_pool_t *pool, const char *file_name,
                         void **file_buffer, apr_size_t *size);

    ThumbnailWriter(const ThumbnailWriter&);
    ThumbnailWriter &operator=(const ThumbnailWriter&);
};

#endif

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
