/******************************************************************************
 * mod_uploader / ApacheUploaderConfig.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: ApacheUploaderConfig.h 1003 2006-03-14 13:52:47Z svn $
 *****************************************************************************/

#ifndef APACHE_UPLOADER_CONFIG_H
#define APACHE_UPLOADER_CONFIG_H

#include "mod_uploader_apache.h"

#include "RFC1867ParserImpl.h"
#include "UploaderConfig.h"

#include "apr_pools.h"
#include "apr_global_mutex.h"
#ifdef LOCK_TYPE_MUTEX
#include "apr_thread_mutex.h"
#else
#include "apr_thread_rwlock.h"
#endif

#include <cstdlib>

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

using namespace std;

/**
 * @brief åץݻ륯饹
 */
class ApacheUploaderConfig : public UploaderConfig {
public:
    static const char URL_PARAM[];
    static const char FILE_DIRECTORY_PARAM[];
    static const char THUMB_DIRECTORY_PARAM[];
    static const char TMP_DIRECTORY_PARAM[];
    static const char VIEW_TEMPLATE_FILE_PARAM[];
    static const char PROGRESS_TEMPLATE_FILE_PARAM[];
    static const char DOWNLOAD_TEMPLATE_FILE_PARAM[];
    static const char THUMB_TEMPLATE_FILE_PARAM[];
    static const char ERROR_TEMPLATE_FILE_PARAM[];
    static const char MAX_FILE_SIZE_PARAM[];
    static const char TOTAL_FILE_SIZE_LIMIT_PARAM[];
    static const char TOTAL_FILE_NUMBER_LIMIT_PARAM[];
    static const char PER_PAGE_ITEM_NUMBER_PARAM[];

    ApacheUploaderConfig();
    ~ApacheUploaderConfig();

    void init(request_rec *r, sconfig *sconfig);
    void finalize();

    void read_lock();
    void read_unlock();
    void gwrite_lock();
    void gwrite_unlock();

    // ݤΤ public
    ApacheRFC1867Parser *uparser;

private:
    void exec_init(apr_size_t revision);
#if APR_HAS_THREADS
    void init_lock();
#endif
    void update_list(apr_size_t revision);

    void write_lock();
    void write_unlock();
    void global_lock();
    void global_unlock();

    apr_global_mutex_t *glock_;
#if APR_HAS_THREADS
#ifdef LOCK_TYPE_MUTEX
    apr_thread_mutex_t *lock_;
#else
    apr_thread_rwlock_t *lock_;
#endif
#endif
};

typedef ApacheUploaderConfig uconfig;

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
