/******************************************************************************
 * mod_uploader / BasicFileWriter.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: BasicFileWriter.h 1003 2006-03-14 13:52:47Z svn $
 *****************************************************************************/

#ifndef BASIC_FILE_WRITER_H
#define BASIC_FILE_WRITER_H

#include "FileWriter.h"

#include "apr_pools.h"

#include <cstdlib>

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

using namespace std;

/**
 * @brief read  write Ȥäơեإǡ񤭽Ф饹
 */
class BasicFileWriter: public FileWriter
{
public:
    /**
     * 󥹥ȥ饯
     *
     * offset ꤵƤϡΰְʹߤ˽񤭽ФԤޤ
     *
     * @param[in] pool ס
     * @param[in] fd եϥɥ
     * @param[in] offset 񤭽Ф򳫻Ϥ
     */
    BasicFileWriter(apr_pool_t *pool, apr_file_t *fd, apr_size_t offset=0);
    /**
     * եؤν񤭽ФԤޤ
     *
     * @param[in] buf 񤭽Фǡ
     * @param[in] size 񤭽Ф
     * @exception const char * 񤭽Ф˼Ԥ
     */
    void write(const void *buf, apr_size_t size);
private:
    BasicFileWriter(const BasicFileWriter&);
    BasicFileWriter &operator=(const BasicFileWriter&);
};

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
