/******************************************************************************
 * mod_uploader / CharCodeConverter.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: CharCodeConverter.h 1003 2006-03-14 13:52:47Z svn $
 *****************************************************************************/

#ifndef CHAR_CODE_CONVERTER_H
#define CHAR_CODE_CONVERTER_H

#include "apr_pools.h"

#include <cstdlib>

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

using namespace std;

/**
 * @brief ʸɤѴԤ饹
 */
class CharCodeConverter
{
public:
    /** ǥեȤʸ */
    static const char DEFAULT_CODE[];

    /**
     * ʸʸɤ򡤥ǥեȤΤΤѴޤ
     *
     * ʸʸɤϡpat ͤ˴ŤưŪȽ̤ޤ
     *
     * @param[in] pool ס
     * @param[in] str ʸ
     * @param[in] pat ֵפ 1 Хܤ
     * @return Ѵʸ
     * @exception const char * ʸɤȽ̤Ǥʤä礪ӡʸɤѴ˼Ԥ硥
     */
    static const char *convert(apr_pool_t *pool, const char *str,
                               const unsigned char *pat);
    /**
     * Ϥʸɤto ǻᤵ줿Ѵޤ
     *
     * @param[in] pool ס
     * @param[in] str ʸ
     * @param[in] from ʸʸ
     * @param[in] to ʸʸ
     * @return Ѵʸ
     * @exception const char * ʸɤѴ˼Ԥ硥
     */
    static const char *convert(apr_pool_t *pool, const char *str,
                               const char *from, const char *to);

private:
    /** ֵפ EUC-JP ɽ 1 Хܤ */
    static const unsigned char EUCJP_PAT_FIRST;
    /** ֵפ Shift-JIS ɽ 1 Хܤ */
    static const unsigned char SJIS_PAT_FIRST;
    /** ֵפ JIS ɽ 1 Хܤ */
    static const unsigned char JIS_PAT_FIRST;
    /** ֵפ UTF-8 ɽ 1 Хܤ */
    static const unsigned char UTF8_PAT_FIRST;

    /**
     * ֵפ 1 Хܤͤ˴ŤʸɤȽ̤ޤ
     *
     * ʸɤEUC-JPShift-JISJISUTF-8 ΤǤʤ硤
     * 㳰ꤲޤ
     *
     * @param[in] pat ֵפ 1 Хܤ
     * @exception const char * ʸɤȽ̤Ǥʤä硥
     */
    static const char *identify_code(const unsigned char *pat);

    CharCodeConverter(const CharCodeConverter&);
    CharCodeConverter &operator=(const CharCodeConverter&);
};

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
