/******************************************************************************
 * mod_uploader / lighttpdResponseWriter.cpp
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: LighttpdResponseWriter.h 1003 2006-03-14 13:52:47Z svn $
 *****************************************************************************/

#ifndef LIGHTTPD_RESPONSE_WRITER_H
#define LIGHTTPD_RESPONSE_WRITER_H

#undef PACKAGE_BUGREPORT
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION
extern "C" {
#include "buffer.h"
}
#undef PACKAGE_BUGREPORT
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION

#include "ResponseWriter.h"

#include "apr.h"

#include <cstdlib>

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

using namespace std;

/**
 * @brief lighttpd ǥ쥹ݥ󥹤񤭽Ф饹
 */
class lighttpdResponseWriter : public ResponseWriter
{
public:
    lighttpdResponseWriter(buffer *response);

    void puts(const char *str)
    {
        buffer_append_string(response_, str);
    };

private:
    buffer *response_;
};

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
