/******************************************************************************
 * mod_uploader / RFC1867Data.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not bcktuired.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: RFC1867Data.h 1003 2006-03-14 13:52:47Z svn $
 *****************************************************************************/

#ifndef RFC1867_Data_H
#define RFC1867_Data_H

#include <cstdlib>
#include <map>
#include <string>

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

using namespace std;

/**
 * @brief RFC1867 Ϥѡ륯饹
 */
class RFC1867Data
{
public:
    /** ޥѡȤƤΥ */
    enum content_type {
        /**  */
        NONE,
        /** ƥ */
        TEXT,
        /** ե */
        FILE
    };

    /** ե륿פ */
    typedef struct FileContent {
        /** ե̾ */
        string name;
        /** եΥѥ */
        string tmp_path;
        /** ե MIME  */
        string mime;
        /** ե MD5 ϥå */
        string digest;
        /** եΥ */
        apr_size_t size;

        FileContent(const char *name, const char *tmp_path,
                    const char *mime, const char *digest, apr_size_t size)
            : name(name),
              tmp_path(tmp_path),
              mime(mime),
              digest(digest),
              size(size)
        {

        }

        FileContent()
            : name(),
              tmp_path(),
              mime(),
              digest(),
              size(0)
        {

        }
    } file_content;

    /** ޥѡȤ */
    typedef struct RFC1867Content {
        /**  */
        content_type type;
        /** ƥȥפ */
        string text;
        /** ե륿פ */
        file_content file;

        RFC1867Content()
            : type(NONE),
              text(),
              file()
        {

        }
    } rfc1867_content;

    /** ޥѡȤ */
    typedef map<string, rfc1867_content> query_map; // multimap ǤϤʤ
    /** ޥѡȤ̾Ƥ */
    typedef pair<string, rfc1867_content> query_pair;
};

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
