/******************************************************************************
 * mod_uploader / TemplateExecutor.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: TemplateExecutor.h 1240 2006-07-23 17:00:41Z svn $
 *****************************************************************************/

#ifndef TEMPLATE_EXECUTOR_H
#define TEMPLATE_EXECUTOR_H

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

#include "TemplateParser.h"
#include "TemplateVariable.h"
#include "TemplateVariableCreator.h"
#include "ResponseWriter.h"

#include "apr_pools.h"

#include <cstdlib>
#include <vector>
#include <map>

using namespace std;

/**
 * @brief ƥץ졼Ȥ¹Ԥ륯饹
 */
template<class ResponseWriterClass>
class TemplateExecutor
{
public:
    TemplateExecutor(apr_pool_t *pool, TemplateParser::ident_map *imap,
                     TemplateVariable::variable_map *vmap,
                     ResponseWriterClass& writer);
    void exec(apr_pool_t *pool, TemplateParser::node *node);

private:
    typedef TemplateParser::ident_map       ident_map;
    typedef TemplateParser::node            node;

    typedef TemplateVariable::scalar        scalar;
    typedef TemplateVariable::scalar_type   scalar_type;
    typedef TemplateVariable::variable_map  variable_map;
    typedef TemplateVariable::variable      variable;
    typedef TemplateVariable::variable_type variable_type;

    TemplateExecutor(const TemplateExecutor&);
    TemplateExecutor &operator=(const TemplateExecutor&);

    void exec_stmt(node *node);
    void exec_foreach(node *node);
    void exec_while(node *node);
    void exec_if(node *node);
    void exec_print(node *node);
    bool calc_b_val(node *node);
    int calc_i_val(node *node);
    int calc_i_val(variable* var);
    variable *get_var(node *node);
    void print(int i_val);
    void print(const char *s_val);

    apr_pool_t *pool_;
    ident_map *imap_;
    variable **vmap_;
    TemplateVariableCreator vcreator_;
    ResponseWriterClass writer_;
};

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
