/******************************************************************************
 * mod_uploader / UploadItemStream.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not bcktuired.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id$
 *****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

#if defined(MOVIE_THUMBNAIL) && defined(MAKE_THUMBNAIL)
#ifndef UPLOAD_ITEM_STREAM_H
#define UPLOAD_ITEM_STREAM_H

#include "apr_file_io.h"

#include <wmsdk.h>
#include <wmsdkidl.h>

const char AVI_DUMMY_EXT[]  = ".MDU+";


/**
 * @brief åץɥƥΥȥ꡼ɽ饹
 */
class UploadItemStream : public IStream
{
public:
    UploadItemStream(apr_pool_t *pool, apr_file_t *file, apr_uint64_t file_size);
    ~UploadItemStream();
    HRESULT STDMETHODCALLTYPE Read(void *buffer, ULONG size, ULONG *read_size);
    HRESULT STDMETHODCALLTYPE Seek(LARGE_INTEGER offset, DWORD origin,
                                   ULARGE_INTEGER *new_position);
    HRESULT STDMETHODCALLTYPE Stat(STATSTG *stat, DWORD stat_flag);
    HRESULT STDMETHODCALLTYPE QueryInterface(REFIID ref_id, void **object);
    ULONG STDMETHODCALLTYPE AddRef();
    ULONG STDMETHODCALLTYPE Release();
    HRESULT STDMETHODCALLTYPE Write(void const *pv, ULONG cb,
                                    ULONG *pcbWritten);
    HRESULT STDMETHODCALLTYPE SetSize(ULARGE_INTEGER libNewSize);
    HRESULT STDMETHODCALLTYPE CopyTo(IStream *pstm, ULARGE_INTEGER cb,
                                     ULARGE_INTEGER *pcbRead,
                                     ULARGE_INTEGER *pcbWritten);
    HRESULT STDMETHODCALLTYPE Commit(DWORD grfCommitFlags);
    HRESULT STDMETHODCALLTYPE Revert();
    HRESULT STDMETHODCALLTYPE LockRegion(ULARGE_INTEGER libOffset,
                                         ULARGE_INTEGER cb, DWORD dwLockType);
    HRESULT STDMETHODCALLTYPE UnlockRegion(ULARGE_INTEGER libOffset,
                                           ULARGE_INTEGER cb,
                                           DWORD dwLockType);
    HRESULT STDMETHODCALLTYPE Clone(IStream **ppstm);

private:
    apr_pool_t *pool_;
    apr_file_t *file_;
    apr_uint64_t file_size_;
    ULONG ref_count_;
};

LRESULT CALLBACK uploadItemIOProc(LPMMIOINFO mminfo, UINT message,
                                  LPARAM param1, LPARAM param2);

#endif

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
