/******************************************************************************
 * mod_uploader / UploaderConfig.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: UploaderConfig.h 1003 2006-03-14 13:52:47Z svn $
 *****************************************************************************/

#ifndef UPLOADER_CONFIG_H
#define UPLOADER_CONFIG_H

#include "mod_uploader_data.h"

#include "UploadItemWriter.h"
#include "UploadItemReader.h"
#include "UploadItemList.h"
#include "TemplateLexer.h"
#include "TemplateParser.h"

#include "apr_pools.h"
#include "apr_time.h"

#include <cstdlib>

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

using namespace std;

/**
 * @brief åץݻ륯饹
 */
class UploaderConfig {
public:
    UploaderConfig();
    virtual ~UploaderConfig();

    virtual void finalize();

    page_template *get_view_template(apr_pool_t *pool);
    page_template *get_progress_template(apr_pool_t *pool);
    page_template *get_download_template(apr_pool_t *pool);
    page_template *get_thumb_template(apr_pool_t *pool);
    page_template *get_error_template(apr_pool_t *pool);

    UploadItemReader *get_ureader(apr_pool_t *pool);
    UploadItemWriter *get_uwriter(apr_pool_t *pool);

    // ݤΤ public
    const char *url;
    const char *file_dir;
    const char *thumb_dir;
    const char *tmp_dir;
    const char *view_tmpl_path;
    const char *progress_tmpl_path;
    const char *download_tmpl_path;
    const char *thumb_tmpl_path;
    const char *error_tmpl_path;
    apr_uint64_t total_file_size_limit;
    apr_size_t total_file_number_limit;
    apr_uint64_t max_file_size;
    apr_size_t per_page_item_number;
    apr_size_t remove_item_number;

    UploadItemList *item_list;

protected:
    static const apr_uint64_t TOTAL_FILE_SIZE_LIMIT;
    static const apr_size_t TOTAL_FILE_NUMBER_LIMIT;
    static const apr_uint64_t MAX_FORM_FILE_SIZE;
    static const apr_size_t MAX_FORM_TEXT_SIZE;
    static const apr_size_t MAX_FORM_ITEM_NUMBER;
    static const apr_size_t PER_PAGE_ITEM_NUMBER;
    static const apr_size_t ITEM_RELOAD_THRESHOLD;

    page_template *view_tmpl_;
    apr_pool_t *view_tmpl_pool_;
    page_template *progress_tmpl_;
    apr_pool_t *progress_tmpl_pool_;
    page_template *download_tmpl_;
    apr_pool_t *download_tmpl_pool_;
    page_template *thumb_tmpl_;
    apr_pool_t *thumb_tmpl_pool_;
    page_template *error_tmpl_;
    apr_pool_t *error_tmpl_pool_;
    apr_pool_t *pool_;
    apr_pool_t *list_pool_;
    volatile bool is_init_;

    void validate();
    void init_template();
    void load_list(apr_size_t revision);
    void load_template(apr_pool_t *pool, apr_pool_t **tmpl_pool,
                       const char *template_path, page_template *tmpl);
    void set_template_imap(apr_pool_t *tmpl_pool, page_template *tmpl,
                           TemplateLexer::ident_map *imap);

    static apr_time_t get_mtime(apr_pool_t *pool, const char *path);
};

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
