/******************************************************************************
 * mod_uploader / WIndowsThumbnailWriter.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: WindowsThumbnailWriter.h 1003 2006-03-14 13:52:47Z svn $
 *****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

#ifdef MAKE_THUMBNAIL
#ifndef WINDOWS_THUMBNAIL_WRITER_H
#define WINDOWS_THUMBNAIL_WRITER_H

#include "ThumbnailWriter.h"
#include "UploadItemStream.h"

#include "apr_pools.h"

#include <list>

using namespace std;


/**
 * @brief Υͥ륯饹
 */
class WindowsThumbnailWriter: public ThumbnailWriter
{
public:
    /**
     * 󥹥ȥ饯Ǥ
     *
     * @param[in] pool ס
     * @param[in] file_dir оݤȤʤե뤬äƤǥ쥯ȥ
     * @param[in] thumb_dir ͥǥ쥯ȥ
     */
    WindowsThumbnailWriter(apr_pool_t *pool,
                           const char *file_dir, const char *thumb_dir);
    /**
     * ϥեΥͥޤ
     *
     * @param[in] file_name ϥե̾
     * @retval true ͥǤ
     * @retval false ͥǤʤä
     * @exception ͥ㳰Ū
     */
    bool write(const char *file_name);

private:
#ifdef MOVIE_THUMBNAIL
    bool wmv_create_movie_thumb(apr_pool_t *pool, const char *file_name);
    UploadItemStream *wmv_open_movie_file(apr_pool_t *pool,
                                          const char *file_name);
    IWMSyncReader *wmv_open_movie(UploadItemStream *stream);
    DWORD wmv_get_stream_number(IWMSyncReader *wmv_reader);
    void wmv_get_stream_info(IWMSyncReader *wmv_reader, WORD stream_number,
                             LONG *frame_width, LONG *frame_height);
    void wmv_select_stream(IWMSyncReader *wmv_reader, WORD stream_number);
    void wmv_read_frame_image(IWMSyncReader *wmv_reader, WORD stream_number,
                              LONG frame_width, LONG frame_height,
                              Magick::Image& frame_image);
    void wmv_read_movie_frames(IWMSyncReader *wmv_reader, WORD stream_number,
                               LONG frame_width, LONG frame_height,
                               double frame_sample, double frame_delay,
                               apr_size_t frame_number,
                               list<Magick::Image> &frame_list);

    bool avi_create_movie_thumb(apr_pool_t *pool, const char *file_name);
    PAVISTREAM avi_open_movie(apr_pool_t *pool, const char *file_name);
    PGETFRAME avi_open_frame(PAVISTREAM stream);
    void avi_stream_info(PAVISTREAM stream,
                         LONG *frame_width, LONG *frame_height);
    void avi_read_frame_image(PGETFRAME frame, LONG frame_index,
                              Magick::Image& frame_image);
    void avi_read_movie_frames(PGETFRAME frame, PAVISTREAM stream,
                               LONG frame_width, LONG frame_height,
                               double frame_sample, double frame_delay,
                               apr_size_t frame_number,
                               list<Magick::Image> &frame_list);
#endif

    WindowsThumbnailWriter(const WindowsThumbnailWriter&);
    WindowsThumbnailWriter &operator=(const WindowsThumbnailWriter&);
};

#endif

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
