/******************************************************************************
 * mod_uploader / mod_uploader_data.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: mod_uploader.h.in 570 2005-09-02 21:21:36Z svn $
 *****************************************************************************/

/**
 * @file
 * @brief mod_uplaoder Ѥǡ¤
 */

#ifndef MOD_UPLOADER_DATA_H
#define MOD_UPLOADER_DATA_H

#undef strtoul

#include "TemplateLexer.h"
#include "TemplateParser.h"
#include "PostReader.h"

#include "apr_time.h"
#include "apr_global_mutex.h"
#include "apr_shm.h"

const apr_size_t MAX_PARAM_LENGTH       = 512;
const apr_size_t MAX_PARAM_NUMBER       = 4;

const char UPLOAD_COMMAND[]             = "upload";
const char PROGRESS_COMMAND[]           = "progress";
const char PROGRESS_DATA_COMMAND[]      = "progress_data";
const char DOWNLOAD_COMMAND[]           = "download";
const char REMOVE_COMMAND[]             = "remove";
const char RSS_COMMAND[]                = "rss";
const char THUMBNAIL_COMMAND[]          = "thumbnail";
const char IMAGE_COMMAND[]              = "image";

const char UPLOAD_LOCK_NAME[]           = "." PACKAGE_NAME ".upload_lock";
const char PROGRESS_LOCK_NAME[]         = "." PACKAGE_NAME ".progress_lock";
const char REVISION_NAME[]              = "." PACKAGE_NAME ".revision";
const char POSTER_LIST_NAME[]           = "." PACKAGE_NAME ".poster_list";
const char PROGRESS_LIST_NAME[]         = "." PACKAGE_NAME ".progress_list";

const apr_size_t MAX_ADDRESS_LENGTH     = 64;

typedef PostReader::progress pprogress;

typedef struct PageTemplate {
    TemplateLexer::ident_map *imap;
    TemplateParser::node *node;
    apr_time_t mtime;

    PageTemplate()
    {
        imap    = NULL;
        node    = NULL;
        mtime   = 0;
    }
} page_template;

typedef struct Poster {
    apr_time_t time;
    char address[MAX_ADDRESS_LENGTH];
} poster;

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
