/******************************************************************************
 * mod_uploader / lighttpdUploaderConfig.cpp
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: LighttpdUploaderConfig.cpp 1003 2006-03-14 13:52:47Z svn $
 *****************************************************************************/

#include "LighttpdUploaderConfig.h"
#include "Misc.h"

#include "apr_strings.h"

#undef DELETE
#define DELETE(ptr) if (ptr != NULL) { delete ptr; ptr = NULL;}
#define DESTROY(pool) if (pool != NULL) { apr_pool_destroy(pool); pool = NULL;}

#ifdef DEBUG
#include <iostream>
#endif

const char lighttpdUploaderConfig::ACTIVATE_PARAM[]                 = "uploader.activate";
const char lighttpdUploaderConfig::PATH_PARAM[]                     = "uploader.path";
const char lighttpdUploaderConfig::URL_PARAM[]                      = "uploader.url";
const char lighttpdUploaderConfig::FILE_DIRECTORY_PARAM[]           = "uploader.file-directory";
const char lighttpdUploaderConfig::THUMB_DIRECTORY_PARAM[]          = "uploader.thumb-directory";
const char lighttpdUploaderConfig::TMP_DIRECTORY_PARAM[]            = "uploader.tmp-directory";
const char lighttpdUploaderConfig::VIEW_TEMPLATE_FILE_PARAM[]       = "uploader.view-template-file";
const char lighttpdUploaderConfig::PROGRESS_TEMPLATE_FILE_PARAM[]   = "uploader.progress-template-file";
const char lighttpdUploaderConfig::DOWNLOAD_TEMPLATE_FILE_PARAM[]   = "uploader.download-template-file";
const char lighttpdUploaderConfig::THUMB_TEMPLATE_FILE_PARAM[]      = "uploader.thumb-template-file";
const char lighttpdUploaderConfig::ERROR_TEMPLATE_FILE_PARAM[]      = "uploader.error-template-file";
const char lighttpdUploaderConfig::MAX_FILE_SIZE_PARAM[]            = "uploader.max-file-size";
const char lighttpdUploaderConfig::TOTAL_FILE_SIZE_LIMIT_PARAM[]    = "uploader.total-file-size-limit";
const char lighttpdUploaderConfig::TOTAL_FILE_NUMBER_LIMIT_PARAM[]  = "uploader.total-file-number-limit";
const char lighttpdUploaderConfig::PER_PAGE_ITEM_NUMBER_PARAM[]     = "uploader.per-page-item-number";


/******************************************************************************
 * public ᥽å
 *****************************************************************************/
lighttpdUploaderConfig::lighttpdUploaderConfig()
    : UploaderConfig(),
      uparser(NULL)
{

}

lighttpdUploaderConfig::~lighttpdUploaderConfig()
{
    finalize();
}

void lighttpdUploaderConfig::init(apr_pool_t *pool)
{
    pool_ = pool;

    validate();
    load_list(0);
    init_template();

    uparser = new lighttpdRFC1867Parser(tmp_dir, MAX_FORM_TEXT_SIZE,
                                        max_file_size, MAX_FORM_ITEM_NUMBER,
                                        sizeof(UploadItem::header));

    is_init_ = true;
}


/******************************************************************************
 * private ᥽å
 *****************************************************************************/
void lighttpdUploaderConfig::update_list()
{
    if (LIKELY(remove_item_number != ITEM_RELOAD_THRESHOLD)) {
        return;
    }

    load_list(0);
}

void lighttpdUploaderConfig::finalize()
{
    DELETE(uparser);

    UploaderConfig::finalize();

    DESTROY(pool_);
}

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
