/******************************************************************************
 * mod_uploader / PostReader.cpp
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: PostReader.cpp 1003 2006-03-14 13:52:47Z svn $
 *****************************************************************************/

#include "PostReader.h"

#ifdef DEBUG
#include <iostream>
#endif

const apr_size_t PostReader::DEFAULT_BLOCK_SIZE = 2048;


/******************************************************************************
 * public ᥽å
 *****************************************************************************/
PostReader::PostReader(progress *progress)
    : block_size_(DEFAULT_BLOCK_SIZE),
      progress_(progress)
{

}

void PostReader::set_block_size(apr_size_t block_size)
{
    block_size_ = block_size;
}

PostReader::~PostReader()
{

}


/******************************************************************************
 * protected ᥽å
 *****************************************************************************/
void PostReader::update(apr_size_t read_size)
{
#ifdef DEBUG
    if (progress_ == NULL) {
        throw "ĽνǤƤޤ";
    }
#endif

    progress_->read_size += read_size;
}

apr_size_t PostReader::get_block_size()
{
    return block_size_;
}


// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
