/******************************************************************************
 * mod_uploader / TemplateExecutor.cpp
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: TemplateExecutor.cpp 1240 2006-07-23 17:00:41Z svn $
 *****************************************************************************/

#include "TemplateExecutor.h"
#include "Misc.h"

#include "apr_strings.h"

#ifdef DEBUG
#include <iostream>
#endif

#ifdef DEBUG
#define UNEXPECTED(value) throw "餯ХǤ" // :-<
#else
#define UNEXPECTED(value) return value
#endif

#ifdef DEBUG_TemplateExecutor
#define TRACE(label) cerr << "call: " << label << endl;
#else
#define TRACE(label)
#endif


/******************************************************************************
 * public ᥽å
 *****************************************************************************/
template<class ResponseWriterClass>
TemplateExecutor<ResponseWriterClass>::TemplateExecutor(apr_pool_t *pool,
                                                        TemplateParser::ident_map *imap,
                                                        TemplateVariable::variable_map *vmap,
                                                        ResponseWriterClass& writer)
    : pool_(pool),
      imap_(imap),
      vcreator_(pool),
      writer_(writer)

{
    // vector ٤Τǡˤ롥

    variable_map::const_iterator i;
    variable_map::const_iterator end = vmap->end();
    apr_size_t j;

    APR_PCALLOC(vmap_, variable **, pool, sizeof(variable *)*vmap->size());

    j = 0;
    for (i = vmap->begin(); i != end; ++i) {
        vmap_[j++] = *i;
    }
}

template<class ResponseWriterClass>
void TemplateExecutor<ResponseWriterClass>::exec(apr_pool_t *pool,
                                                 TemplateParser::node *node)
{
    TRACE("exec");

    vcreator_.set_pool(pool);

    exec_stmt(node);
}


/******************************************************************************
 * private ᥽å
 *****************************************************************************/
template<class ResponseWriterClass>
void TemplateExecutor<ResponseWriterClass>::exec_stmt(node *node)
{
    TRACE("exec_stmt");

    while (node != NULL) {
        switch (node->branch.left->type) {
        case TemplateParser::PRINT:         // PRINT
            exec_print(node->branch.left);
            break;
        case TemplateParser::IF:            // IF
            exec_if(node->branch.left);
            break;
        case TemplateParser::FOREACH:       // FOREACH
            exec_foreach(node->branch.left);
            break;
        case TemplateParser::WHILE:         // WHILE
            exec_while(node->branch.left);
            break;
        default:
            calc_i_val(node->branch.left);
            break;
        }

        node = node->branch.right;
    }
}

template<class ResponseWriterClass>
void TemplateExecutor<ResponseWriterClass>::exec_foreach(node *node)
{
    TRACE("exec_foreach");

    variable *array_var = vmap_[node->branch.center->i_val];
    apr_size_t index_id = node->branch.left->i_val;

    if (UNLIKELY(array_var == NULL)) {
        throw "Ƥʤѿ򻲾Ȥޤ";
    } else if (UNLIKELY(array_var->type != TemplateVariable::ARRAY)) {
        throw "ɬפʾˤ¾ѿꤵƤޤ";
    }

    apr_size_t array_size = array_var->a_val->nelts;
    for (apr_size_t i = 0; i < array_size; ++i) {
        vmap_[index_id]= *(reinterpret_cast<variable **>(array_var->a_val->elts) + i);

        exec_stmt(node->branch.right);
    }
}

template<class ResponseWriterClass>
void TemplateExecutor<ResponseWriterClass>::exec_while(node *node)
{
    TRACE("exec_while");

    while (calc_b_val(node->branch.left)) {
        exec_stmt(node->branch.right);
    }
}

template<class ResponseWriterClass>
void TemplateExecutor<ResponseWriterClass>::exec_if(node *node)
{
    TRACE("exec_if");

    if (calc_b_val(node->branch.center)) {
        exec_stmt(node->branch.left);
    } else if (node->branch.right != NULL) {
        exec_stmt(node->branch.right);
    }
}

template<class ResponseWriterClass>
void TemplateExecutor<ResponseWriterClass>::exec_print(node *node)
{
    TRACE("exec_print");

    variable *var;
    node = node->branch.left;

    while (node != NULL) {
        switch (node->branch.left->type) {
        case TemplateParser::STRING:        // ʸ
            print(node->branch.left->s_val);
            break;
        case TemplateParser::IDENTIFIER:    // ̻
            var = vmap_[node->branch.left->i_val];
            goto VAR;
        case TemplateParser::HASH_REF:      // .
            var = get_var(node->branch.left);
            goto VAR;
        case TemplateParser::ARRAY_REF:     // []
            var = get_var(node->branch.left);
            goto VAR;
        VAR:
            if (UNLIKELY(var == NULL)) {
                throw "Ƥʤѿ򻲾Ȥޤ";
            }

            if ((var->type == TemplateVariable::SCALAR) &&
                (var->s_val->type == TemplateVariable::STRING)) {
                print(var->s_val->s_val);
            } else {
                print(calc_i_val(var));
            }
            break;
        default:
            print(calc_i_val(node->branch.left));
            break;
        }

        node = node->branch.right;
    }
}

template<class ResponseWriterClass>
bool TemplateExecutor<ResponseWriterClass>::calc_b_val(node *node)
{
    TRACE("calc_b_val");

    switch (node->type) {
    case TemplateParser::EQUAL:
        return calc_i_val(node->branch.left) == calc_i_val(node->branch.right);
    case TemplateParser::NOTEQUAL:
        return calc_i_val(node->branch.left) != calc_i_val(node->branch.right);
    case TemplateParser::GREATER_THAN:
        return calc_i_val(node->branch.left) > calc_i_val(node->branch.right);
    case TemplateParser::LESS_THAN:
        return calc_i_val(node->branch.left) < calc_i_val(node->branch.right);
    default:
        UNEXPECTED(false);
    }
}

template<class ResponseWriterClass>
int TemplateExecutor<ResponseWriterClass>::calc_i_val(node *node)
{
    TRACE("calc_i_val");

    int value = 0;
    int diff;
    apr_size_t ident_id;
    variable *var = NULL;
    variable *ref_var;
    scalar *s_val;

    switch (node->type) {
    case TemplateParser::STRING:            // STRING
        return static_cast<int>(strlen(node->s_val));
    case TemplateParser::IDENTIFIER:        // IDENTIFIER
        var = vmap_[node->i_val];

        if (UNLIKELY(var == NULL)) {
            throw "Ƥʤѿ򻲾Ȥޤ";
        }

        return calc_i_val(var);
    case TemplateParser::INTEGER:           // INTEGR
        return node->i_val;
    case TemplateParser::ASSIGNMENT:        // =
        ident_id = node->branch.left->i_val;

        switch (node->branch.right->type) {
        case TemplateParser::IDENTIFIER:    // ̻
        case TemplateParser::ARRAY_REF:     // []
        case TemplateParser::HASH_REF:      // .
            ref_var = get_var(node->branch.right);
            if (UNLIKELY(ref_var == NULL)) {
                throw "Ƥʤѿ򻲾Ȥޤ";
            }

            if ((ref_var->type == TemplateVariable::SCALAR) &&
                (ref_var->s_val->type == TemplateVariable::INTEGER)) {
                var = vmap_[ident_id];
                if (var == NULL) {
                    var = vcreator_.create_variable(TemplateVariable::SCALAR);
                    var->s_val = vcreator_.create_scalar(TemplateVariable::INTEGER);

                    vmap_[ident_id] = var;
                } else {
                    var->type = TemplateVariable::SCALAR;
                    var->s_val->type = TemplateVariable::INTEGER;
                }

                var->s_val->i_val = ref_var->s_val->i_val;
            } else { // Ͱʳϥԡʤ
                vmap_[ident_id] = ref_var;
            }

            return calc_i_val(var);
        case TemplateParser::STRING:        // ʸ
            var = vmap_[ident_id];
            if (var == NULL) {
                var = vcreator_.create_variable(TemplateVariable::SCALAR);
                var->s_val = vcreator_.create_scalar(TemplateVariable::STRING);

                // ԡϤʤ
                var->s_val->s_val = node->branch.right->s_val;

                vmap_[ident_id] = var;
            } else {
                var->type = TemplateVariable::SCALAR;

                if (var->s_val == NULL) {
                    var->s_val = vcreator_.create_scalar(TemplateVariable::STRING);
                } else {
                    var->s_val->type = TemplateVariable::STRING;
                }

                // ԡϤʤ
                var->s_val->s_val = node->branch.right->s_val;
            }

            return calc_i_val(var);
        default:                            // 
            var = vmap_[ident_id];
            if (var == NULL) {
                var = vcreator_.create_variable(TemplateVariable::SCALAR);
                var->s_val = vcreator_.create_scalar(TemplateVariable::INTEGER);
                var->s_val->i_val = calc_i_val(node->branch.right);

                vmap_[ident_id] = var;
            } else {
                var->type = TemplateVariable::SCALAR;

                if (var->s_val == NULL) {
                    var->s_val = vcreator_.create_scalar(TemplateVariable::INTEGER);
                } else {
                    var->s_val->type = TemplateVariable::INTEGER;
                }
                var->s_val->i_val = calc_i_val(node->branch.right);
            }
            return calc_i_val(var);
        }
    case TemplateParser::PLUS_ASSIGNMENT:   // +=
        diff = calc_i_val(node->branch.right);
        goto ASSIGN2;
    case TemplateParser::MINUS_ASSIGNMENT:  // -=
        diff = -calc_i_val(node->branch.right);
        goto ASSIGN2;
    ASSIGN2:
        ident_id = node->branch.left->i_val;
        var = vmap_[ident_id];

        if (var == NULL) {
            var = vcreator_.create_variable(TemplateVariable::SCALAR);
            var->s_val = vcreator_.create_scalar(TemplateVariable::INTEGER);
            var->s_val->i_val = diff;

            vmap_[ident_id] = var;

            return var->s_val->i_val;
        } else {
            var->type = TemplateVariable::SCALAR;
            var->s_val->type = TemplateVariable::INTEGER;
            var->s_val->i_val = calc_i_val(var) + diff;

            return var->s_val->i_val;
        }
    case TemplateParser::PLUSPLUS:          // ++
        diff = 1;
        goto MONADIC;
    case TemplateParser::MINUSMINUS:        // --
        diff = -1;
        goto MONADIC;
    MONADIC:
        if (node->branch.left != NULL) {
            ident_id = node->branch.left->i_val;
            var = vmap_[ident_id];

            if (UNLIKELY(var == NULL)) {
                throw "Ƥʤѿ򻲾Ȥޤ";
            } else if (UNLIKELY(var->type != TemplateVariable::SCALAR)) {
                throw "SCALAR ɬפʾǤʳѿĤޤ";
            }

            var->type = TemplateVariable::SCALAR;

            s_val = var->s_val;
            s_val->type = TemplateVariable::INTEGER;
            s_val->i_val = calc_i_val(var);
            value = s_val->i_val;
            s_val->i_val += diff;
        } else if (node->branch.right != NULL) {
            ident_id = node->branch.right->i_val;
            var = vmap_[ident_id];

            if (UNLIKELY(var == NULL)) {
                throw "Ƥʤѿ򻲾Ȥޤ";
            } else if (UNLIKELY(var->type != TemplateVariable::SCALAR)) {
                throw "SCALAR ɬפʾǤʳѿĤޤ";
            }

            var->type = TemplateVariable::SCALAR;

            s_val = var->s_val;
            s_val->type = TemplateVariable::INTEGER;
            s_val->i_val = calc_i_val(var);
            s_val->i_val += diff;
            value = s_val->i_val;
        } else {
            UNEXPECTED(0);
        }
        return value;
    case TemplateParser::PLUS:              // +
        return calc_i_val(node->branch.left) + calc_i_val(node->branch.right);
    case TemplateParser::MINUS:             // -
        return calc_i_val(node->branch.left) - calc_i_val(node->branch.right);
    case TemplateParser::RESIDUE:           // %
        return calc_i_val(node->branch.left) % calc_i_val(node->branch.right);
    default:
        UNEXPECTED(0);
    }
}

template<class ResponseWriterClass>
int TemplateExecutor<ResponseWriterClass>::calc_i_val(variable* var)
{
    switch (var->type) {
    case TemplateVariable::SCALAR:
        if (var->s_val->type == TemplateVariable::INTEGER) {
            return var->s_val->i_val;
        } else {
            return static_cast<int>(strlen(var->s_val->s_val));
        }
    case TemplateVariable::ARRAY:
        return var->a_val->nelts;
    case TemplateVariable::HASH:
        return apr_hash_count(var->h_val);
    default:
        UNEXPECTED(0);
    }
}

template<class ResponseWriterClass>
typename TemplateExecutor<ResponseWriterClass>::variable *
TemplateExecutor<ResponseWriterClass>::get_var(node *node)
{
    // ϢޤλͤϤӤߤ硼

    TRACE("get_var");

    variable *var = NULL;
    const char *key;

    switch (node->type) {
    case TemplateParser::IDENTIFIER:    // IDENTIFIER
        var = vmap_[node->i_val];
        break;
    case TemplateParser::ARRAY_REF:     // []
        var = vmap_[node->branch.left->i_val];
        if (var == NULL) {
            break;
        } else if (UNLIKELY(var->type != TemplateVariable::ARRAY)) {
            throw "ɬפʾˤ¾ѿꤵƤޤ";
        }

        if (node->branch.right->type == TemplateParser::INTEGER) { // foo[var]
            var = *(reinterpret_cast<variable **>(var->a_val->elts) +
                    calc_i_val(node->branch.right));
        } else if (node->branch.right->type == TemplateParser::HASH_REF) { // foo[var].baz
            var = *(reinterpret_cast<variable **>(var->a_val->elts) +
                    calc_i_val(node->branch.right->branch.left));

            if (var == NULL) {
                break;
            } else if (UNLIKELY(var->type != TemplateVariable::HASH)) {
                throw "Ϣɬפʾˤ¾ѿꤵƤޤ";
            }
            key = node->branch.right->branch.right->s_val;
            var = static_cast<variable *>(apr_hash_get(var->h_val, key,
                                                            APR_HASH_KEY_STRING));
        }
        break;
    case TemplateParser::HASH_REF:      // .
        var = vmap_[node->branch.left->i_val];
        if (var == NULL) {
            break;
        } else if (UNLIKELY(var->type != TemplateVariable::HASH)) {
            throw "Ϣɬפʾˤ¾ѿꤵƤޤ";
        }

        key = imap_->at(node->branch.right->i_val);

        var = static_cast<variable *>(apr_hash_get(var->h_val, key,
                                                        APR_HASH_KEY_STRING));
        break;
    default:
        if (UNLIKELY(var == NULL)) {
            throw "ХǤ";
        }
    }

    if (UNLIKELY(var == NULL)) {
        throw "Ƥʤѿ򻲾Ȥޤ";
    }

    return var;
}

template<class ResponseWriterClass>
inline void TemplateExecutor<ResponseWriterClass>::print(int i_val)
{
#ifdef DEBUG_TEMPLATE
    cout << i_val;
#else
    print(apr_itoa(pool_, i_val));
#endif
}

template<class ResponseWriterClass>
inline void TemplateExecutor<ResponseWriterClass>::print(const char *s_val)
{
#ifdef DEBUG_TEMPLATE
    cout << s_val;
#else
    writer_.puts(s_val);
#endif
}

/******************************************************************************
 * ƥ
 *****************************************************************************/
#ifdef DEBUG_TemplateExecutor
#include "apr_general.h"
#include "apr_file_io.h"
#include "apr_mmap.h"

#undef PACKAGE_BUGREPORT
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION

#include "UploadItemList.h"
#include "mod_uploader.h"

const apr_size_t TOTAL_NUMBER_LIMIT = 100;
const apr_size_t TOTAL_SIZE_LIMIT   = 1024*1024*1024;

void usage(const char *prog_name)
{
    cerr << "Usage: " << prog_name << " <DIRECTORY> <TEMPLATE>" << endl;
}

int main(int argc, const char * const *argv)
{
    apr_pool_t *pool;
    apr_file_t *fd;
    apr_mmap_t *file_map;
    apr_finfo_t info;
    TemplateParser::node *node;
    apr_size_t ident_id;

    apr_app_initialize(&argc, &argv, NULL);
    apr_pool_create(&pool, NULL);

    try {
        if (argc != 3) {
            throw "եѥǥ쥯ȥѤΥե뤬ꤵƤޤ";
        }

        if (apr_file_open(&fd, argv[2], APR_READ,
                          APR_OS_DEFAULT, pool) != APR_SUCCESS) {
            throw "ե open ˼Ԥޤ";
        }

        if (apr_file_info_get(&info, APR_FINFO_SIZE, fd) != APR_SUCCESS) {
            throw "ե륵ǤޤǤ";
        }

        if (apr_mmap_create(&file_map, fd, 0,
                            static_cast<apr_size_t>(info.size), APR_MMAP_READ,
                            pool) != APR_SUCCESS) {
            throw "ե mmap ˼Ԥޤ";
        }

        TemplateLexer lexer(pool,
                            static_cast<const char *>(file_map->mm),
                            static_cast<apr_size_t>(info.size));
        TemplateParser parser(pool);
        node = parser.parse(lexer.get_token_list(), lexer.get_ident_map());

        TemplateExecutor executor;
        TemplateExecutor::variable_map vmap(lexer.get_ident_map()->size()+SYSTEM_KEY_NUMBER, NULL);

        auto_ptr<UploadItemList> item_list(UploadItemList::load(pool, argv[1], argv[1],
                                                                TOTAL_NUMBER_LIMIT, TOTAL_SIZE_LIMIT));
        ident_id = TemplateExecutor::get_ident_id(lexer.get_ident_map(), FILE_LIST_KEY);
        vmap.at(ident_id) = item_list->to_varray(pool, 0, item_list->size());

        executor.exec(pool, NULL, node, lexer.get_ident_map(), &vmap);

        if (apr_mmap_delete(file_map) != APR_SUCCESS) {
            throw "ե unmap ˼Ԥޤ";
        }

        if (apr_file_close(fd) != APR_SUCCESS) {
            throw "ե close ˼Ԥޤ";
        }
    } catch(const char *message) {
        cerr << "Error: " << message << endl;
        usage(argv[0]);

        return EXIT_FAILURE;
    }

    apr_terminate();

    return EXIT_SUCCESS;

}
#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
