/******************************************************************************
 * mod_uploader / TemplateVariableCreator.cpp
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: TemplateVariableCreator.cpp 1240 2006-07-23 17:00:41Z svn $
 *****************************************************************************/

#include "TemplateVariableCreator.h"
#include "Misc.h"

#ifdef DEBUG
#include <iostream>
#endif

const apr_size_t TemplateVariableCreator::VARIABLE_POOL_NUM = TEXECUTOR_VARIABLE_POOL_NUM;
const apr_size_t TemplateVariableCreator::SCALAR_POOL_NUM   = TEXECUTOR_SCALAR_POOL_NUM;


/******************************************************************************
 * public ᥽å
 *****************************************************************************/
TemplateVariableCreator::TemplateVariableCreator(apr_pool_t *pool)
    : pool_(pool),
      variable_pool_(NULL),
      variable_pool_end_(NULL),
      scalar_pool_(NULL),
      scalar_pool_end_(NULL)
{

}

TemplateVariable::variable *TemplateVariableCreator::create_variable(TemplateVariable::variable_type type)
{
    if (UNLIKELY(variable_pool_ == variable_pool_end_)) {
        APR_PALLOC(variable_pool_, variable *, pool_, sizeof(variable)*VARIABLE_POOL_NUM);

        variable_pool_end_ = variable_pool_ + VARIABLE_POOL_NUM;
    }

    variable *variable = variable_pool_++;
    variable->type = type;

    return variable;
}

TemplateVariable::scalar *TemplateVariableCreator::create_scalar(TemplateVariable::scalar_type type)
{
    if (UNLIKELY(scalar_pool_ == scalar_pool_end_)) {
        APR_PALLOC(scalar_pool_, scalar *, pool_, sizeof(scalar)*SCALAR_POOL_NUM);

        scalar_pool_end_ = scalar_pool_ + SCALAR_POOL_NUM;
    }

    scalar *scalar = scalar_pool_++;
    scalar->type = type;

    return scalar;
}

void TemplateVariableCreator::set_pool(apr_pool_t *pool)
{
    pool_ = pool;
}

apr_size_t TemplateVariableCreator::get_ident_id(TemplateVariable::ident_map *imap,
                                                 const char *name)
{
    apr_size_t imap_size  = imap->size();
    apr_size_t id;

    for (id = 0; id < imap_size; id++) {
        if (strcmp(imap->at(id), name) == 0) {
            return id;
        }
    }

    return id;
}

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
