/******************************************************************************
 * mod_uploader / mod_uploader_fs.cpp
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: mod_uploader_fs.cpp 1063 2006-05-13 03:10:51Z svn $
 *****************************************************************************/

/**
 * @file
 * @brief åץɥեѤ FUSE
 */

#include "UploadItemReader.h"

#include <fuse.h>
#include <fcntl.h>
#include <dirent.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

#include <string>

using namespace std;

static char *file_dir_path_;
struct fuse_operations mod_uploader_fs_op;

static bool get_real_file_name(const char *name, string &file_name)
{
    apr_pool_t *pool;
    DIR *file_dir;
    struct dirent *file_dir_entry;
    UploadItem::header *header;
    apr_file_t *file;

    apr_pool_create(&pool, NULL);

    file_dir = opendir(file_dir_path_);
    if (file_dir == NULL) {
        return false;
    }

    while ((file_dir_entry = readdir(file_dir)) != NULL) {
        if (file_dir_entry->d_name[0] == '.') {
            continue;
        }

        UploadItemReader reader(pool, file_dir_path_);
        header = reader.read(file_dir_entry->d_name, &file);
        apr_file_close(file);

        if (strcmp(header->file_name, name) == 0) {
            file_name = file_dir_entry->d_name;
            closedir(file_dir);
            apr_pool_destroy(pool);
            return true;
        }
    }

    closedir(file_dir);
    apr_pool_destroy(pool);

    return false;
}

static bool get_real_file_path(const char *path, string &file_path)
{
    string file_name;

    // path ɬ 1 ʸʾ
    if ((strcmp(path, "/") == 0) || (path[1] == '.')) {
        file_name += path + 1;
    } else {
        if (!(get_real_file_name(path + 1, file_name))) {
            return false;
        }
    }

    file_path += file_dir_path_;
    file_path += "/";
    file_path += file_name;

    return true;
}

static int mod_uploader_fs_getattr(const char *path, struct stat *stbuf)
{
    string file_path;

    if (!get_real_file_path(path, file_path)) {
        return -ENOENT;
    }

    memset(stbuf, 0, sizeof(struct stat));
    if (lstat(file_path.c_str(), stbuf) == -1) {
        return -errno;
    }

    if (stbuf->st_size < UploadItem::ITEM_HEADER_SIZE) {
        return -ENOENT;
    }

    stbuf->st_size -= UploadItem::ITEM_HEADER_SIZE;

    return 0;
}

static int mod_uploader_fs_readdir(const char *path, void *buf, fuse_fill_dir_t filler,
                         off_t offset, struct fuse_file_info *fi)
{
    apr_pool_t *pool;
    DIR *file_dir;
    struct dirent *file_dir_entry;
    struct stat file_stat;
    UploadItem::header *header;
    apr_file_t *file;

    if (strcmp(path, "/") != 0) {
        return -ENOENT;
    }

    apr_pool_create(&pool, NULL);

    file_dir = opendir(file_dir_path_);
    if (file_dir == NULL) {
         return -errno;
    }

    filler(buf, ".", NULL, 0);
    filler(buf, "..", NULL, 0);

    while ((file_dir_entry = readdir(file_dir)) != NULL) {
        if (file_dir_entry->d_name[0] == '.') {
            continue;
        }

        memset(&file_stat, 0, sizeof(file_stat));

        file_stat.st_ino = file_dir_entry->d_ino;
        file_stat.st_mode = file_dir_entry->d_type << 12;

        UploadItemReader reader(pool, file_dir_path_);
        header = reader.read(file_dir_entry->d_name, &file);
        apr_file_close(file);

        if (filler(buf, header->file_name, &file_stat, 0)) {
            break;
        }
    }

    closedir(file_dir);

    apr_pool_destroy(pool);

    return 0;
}

static int mod_uploader_fs_open(const char *path, struct fuse_file_info *fi)
{
    string file_path;
    int file;

    if (!get_real_file_path(path, file_path)) {
        return -ENOENT;
    }

    file = open(file_path.c_str(), fi->flags);
    if (file == -1) {
        return -errno;
    }

    close(file);

    return 0;
}

static int mod_uploader_fs_read(const char *path, char *buf, size_t size, off_t offset,
                      struct fuse_file_info *fi)
{
    string file_name;
    string file_path(file_dir_path_);
    int file;
    int status;

    if ((strcmp(path, "/") == 0) || (path[1] == '.')) {
        file_name = path + 1;
    } else {
        if (!(get_real_file_name(path + 1, file_name))) {
            return -ENOENT;
        }
    }

    file_path += "/";
    file_path += file_name;

    file = open(file_path.c_str(), O_RDONLY);
    if (file == -1) {
        return -errno;
    }

    status = pread(file, buf, size, offset+UploadItem::ITEM_HEADER_SIZE);

    if (status == -1) {
        status = -errno;
    }

    close(file);

    return status;
}

static void validate_file_dir_path()
{
    if (file_dir_path_[0] != '/') {
        fprintf(stderr,
                "åץɥե¸Ƥǥ쥯ȥХѥǻꤷƤ\n");
        exit(EXIT_FAILURE);
    }

    // Ρ/פ롥
    // ʾΥåˤꡤstrlen(file_dir_path)  1 ʾǤ뤳ȤݾڤƤ
    if (file_dir_path_[strlen(file_dir_path_)-1] == '/') {
        file_dir_path_[strlen(file_dir_path_)-1] = '\0';
    }
}

static void usage(const char *prog_name)
{
    const char *fuse_help[] = { prog_name, "-ho", NULL };

    fprintf(stderr, "usage: %s path mountpoint [options]\n\n", prog_name);
    fuse_main(2, const_cast<char **>(fuse_help), &mod_uploader_fs_op);
    exit(EXIT_FAILURE);
}

static void read_arguments(int argc, const char * const *argv,
                           int *fuse_argc, char ***fuse_argv)
{
    if (argc < 3) {
        usage(argv[0]);
    }

    *fuse_argc = 0;
    *fuse_argv = const_cast<char **>(argv);
    (*fuse_argv)[(*fuse_argc)++] = const_cast<char *>(argv[0]);

    //  strdup ǳݤ줿ϡץཪλޤǲޤ
    // ()
    file_dir_path_ = strdup(argv[1]);

    for (int i = 2; i < argc; i++) {
        if ((strcmp(argv[i], "-h") == 0) || (strcmp(argv[i], "--help") == 0)) {
            usage(argv[0]);
        }

        (*fuse_argv)[(*fuse_argc)++] = const_cast<char *>(argv[i]);
    }
}

int main(int argc, const char * const *argv)
{
    int fuse_argc;
    char **fuse_argv;

    apr_app_initialize(&argc, &argv, NULL);

    read_arguments(argc, argv, &fuse_argc, &fuse_argv);
    validate_file_dir_path();

    mod_uploader_fs_op.getattr = mod_uploader_fs_getattr;
    mod_uploader_fs_op.readdir = mod_uploader_fs_readdir;
    mod_uploader_fs_op.open = mod_uploader_fs_open;
    mod_uploader_fs_op.read = mod_uploader_fs_read;

    return fuse_main(fuse_argc, fuse_argv, &mod_uploader_fs_op);
}

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
