/******************************************************************************
 * mod_uploader / uploader_func.cpp
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: uploader_func.cpp 1240 2006-07-23 17:00:41Z svn $
 *****************************************************************************/

#define __STDC_CONSTANT_MACROS

#include "uploader_func.h"
#include "UploadVariableCreator.h"
#include "CharCodeConverter.h"
#include "Auxiliary.h"
#include "Misc.h"

#include "apr_strings.h"

#ifdef DEBUG
#include <iostream>
#endif

#if _MSC_VER >= 1400
const char *safe_getenv(apr_pool_t *pool, const char *key)
{
    static const size_t BUFFER_SIZE = 512;

    char *buffer;
    apr_size_t required_size;

    APR_PALLOC(buffer, char *, pool, BUFFER_SIZE);
    if (getenv_s(&required_size, buffer, BUFFER_SIZE, key)) {
        return "";
    }

    return buffer;
}
#else
const char *safe_getenv(apr_pool_t *pool, const char *key)
{
    const char *value;

    value = getenv(key);

    if (UNLIKELY(value == NULL)) {
        return "";
    } else {
        return value;
    }
}
#endif

apr_size_t get_page(const char *query)
{
    apr_size_t page;

    page = 0;

    if (query != NULL) {
        page = static_cast<apr_size_t>(atoi(query));
    }

    if (page == 0) {
        page = 1;
    }

    return page;
}

apr_uint32_t get_upload_id(const char *query)
{
    apr_uint32_t upload_id;

    upload_id = 0;

    if (query != NULL) {
        upload_id = static_cast<apr_uint32_t>(atoi(query));
    }

    return upload_id;
}

const char *get_name_encoding(const char *user_agent)
{
    const char *encoding;

    encoding = CharCodeConverter::DEFAULT_CODE;

    if (user_agent == NULL) {
        return encoding;
    }

    // 㤷Ū
    if ((strstr(user_agent, "compatible; MSIE") != NULL) ||
        (strstr(user_agent, "Sleipnir") != NULL)) {
        encoding = IE_NAME_CODE;
    } else if ((strstr(user_agent, "Firefox") != NULL) ||
               (strstr(user_agent, "Mozilla") != NULL)) {
        encoding = FIREFOX_NAME_CODE;
    }

    return encoding;
}

const char *get_token(apr_pool_t *pool, const char **str, const char delimiter)
{
    const char *pos;
    apr_size_t length;
    char *token;

    pos = *str;
    while ((*pos != '\0') && (*pos != delimiter)) {
        pos++;
    }

    length = pos - *str;
    APR_PCALLOC(token, char *, pool, length + 1);

    memcpy(token, *str, length);

    while (*pos == delimiter) {
        pos++;
    }
    *str = pos;

    return token;
}

bool is_modified_since(apr_pool_t *pool, const char *str, apr_time_t mtime)
{
    return mtime > parse_rfc822(pool, str);
}

variable *create_variable(TemplateVariableCreator& creator, const char *str)
{
    variable *var;

    var = creator.create_variable(TemplateVariable::SCALAR);
    var->s_val = creator.create_scalar(TemplateVariable::STRING);
    var->s_val->s_val = str;

    return var;
}

variable *create_variable(TemplateVariableCreator& creator, int i)
{
    variable *var;

    var = creator.create_variable(TemplateVariable::SCALAR);
    var->s_val = creator.create_scalar(TemplateVariable::INTEGER);
    var->s_val->i_val = i;

    return var;
}

variable_map *get_view_vmap(apr_pool_t *pool, UploaderConfig *config,
                            page_template *tmpl, apr_size_t page)
{
    apr_size_t ident_id;
    variable_map *vmap;
    apr_size_t page_number;

    vmap = new variable_map(tmpl->imap->size()+SYSTEM_KEY_NUMBER, NULL);

    page_number = config->item_list->empty()
        ? 1
        : (config->item_list->size()-1)/config->per_page_item_number + 1;

    if (page > page_number) {
        page = page_number;
    }

    TemplateVariableCreator creator(pool);

    ident_id = TemplateVariableCreator::get_ident_id(tmpl->imap, PAGE_NUMBER_KEY);
    vmap->at(ident_id) = create_variable(creator, static_cast<int>(page_number));

    ident_id = TemplateVariableCreator::get_ident_id(tmpl->imap, FILE_LIST_KEY);
    vmap->at(ident_id) = config->item_list->to_varray(pool,
                                                      (page-1)*config->per_page_item_number,
                                                      config->per_page_item_number);

    ident_id = TemplateVariableCreator::get_ident_id(tmpl->imap, CURRENT_PAGE_KEY);
    vmap->at(ident_id) = create_variable(creator, static_cast<int>(page));

    ident_id = TemplateVariableCreator::get_ident_id(tmpl->imap, TOTAL_FILE_SIZE_KEY);
    vmap->at(ident_id) = create_variable(creator,
                                         size_str(pool, config->item_list->get_total_file_size()));

    ident_id = TemplateVariableCreator::get_ident_id(tmpl->imap, TOTAL_FILE_SIZE_KEY);
    vmap->at(ident_id) = create_variable(creator,
                                         size_str(pool, config->item_list->get_total_file_size()));

    ident_id = TemplateVariableCreator::get_ident_id(tmpl->imap, TOTAL_FILE_NUMBER_KEY);
    vmap->at(ident_id) = create_variable(creator,
                                         comma_str(pool, config->item_list->size()));

    ident_id = TemplateVariableCreator::get_ident_id(tmpl->imap, MAX_FILE_SIZE_KEY);
    vmap->at(ident_id) = create_variable(creator,
                                         size_str(pool, config->max_file_size));

    ident_id = TemplateVariableCreator::get_ident_id(tmpl->imap, TOTAL_FILE_SIZE_LIMIT_KEY);
    vmap->at(ident_id) = create_variable(creator,
                                         size_str(pool, config->total_file_size_limit));

    return vmap;
}

variable_map *get_progress_vmap(apr_pool_t *pool, UploaderConfig *config,
                                page_template *tmpl)
{
    variable_map *vmap;

    vmap = new variable_map(tmpl->imap->size()+SYSTEM_KEY_NUMBER, NULL);

    return vmap;
}

variable_map *get_download_vmap(apr_pool_t *pool, UploaderConfig *config,
                                page_template *tmpl, UploadItem::header *header)
{
    apr_size_t ident_id;
    variable_map *vmap;
    UploadItem item(pool);

    TemplateVariableCreator creator(pool);

    vmap = new variable_map(tmpl->imap->size()+SYSTEM_KEY_NUMBER, NULL);
    ident_id = TemplateVariableCreator::get_ident_id(tmpl->imap, FILE_KEY);

    item.set_data("", header); // :-)
    vmap->at(ident_id) = UploadVariableCreator::create(pool, &item);

    return vmap;
}

#ifdef MAKE_THUMBNAIL
variable_map *get_thumb_vmap(apr_pool_t *pool, UploaderConfig *config,
                            page_template *tmpl, apr_size_t page)
{
    apr_size_t ident_id;
    variable_map *vmap;
    apr_size_t page_number;

    vmap = new variable_map(tmpl->imap->size()+SYSTEM_KEY_NUMBER, NULL);

    page_number = (config->item_list->get_thumb_size() == 0)
        ? 1
        : (config->item_list->get_thumb_size()-1)/config->per_page_item_number + 1;

    if (page > page_number) {
        page = page_number;
    }

    TemplateVariableCreator creator(pool);

    ident_id = TemplateVariableCreator::get_ident_id(tmpl->imap, PAGE_NUMBER_KEY);
    vmap->at(ident_id) = create_variable(creator, static_cast<int>(page_number));

    ident_id = TemplateVariableCreator::get_ident_id(tmpl->imap, THUMB_LIST_KEY);
    vmap->at(ident_id) = config->item_list->to_thumb_varray(pool,
                                                            (page-1)*config->per_page_item_number,
                                                            config->per_page_item_number);

    ident_id = TemplateVariableCreator::get_ident_id(tmpl->imap, CURRENT_PAGE_KEY);
    vmap->at(ident_id) = create_variable(creator, static_cast<int>(page));

    ident_id = TemplateVariableCreator::get_ident_id(tmpl->imap, THUMB_NUMBER_KEY);
    vmap->at(ident_id) = create_variable(creator,
                                         comma_str(pool, config->item_list->get_thumb_size()));

    return vmap;
}
#endif

variable_map *get_error_vmap(apr_pool_t *pool, UploaderConfig *config,
                             page_template *tmpl, const char *error)
{
    variable_map *vmap;
    apr_size_t ident_id;

    vmap = new variable_map(tmpl->imap->size(), NULL);

    ident_id = TemplateVariableCreator::get_ident_id(tmpl->imap, ERROR_MESSAGE_KEY);
    vmap->at(ident_id) = UploadVariableCreator::create(pool, error);

    return vmap;
}

pprogress *get_progress(pprogress *progress_list, apr_uint32_t upload_id)
{
    apr_size_t i;

    if (upload_id == 0) {
        return progress_list;
    }

    for (i = 1; i < PROGRESS_LIST_NUMBER; ++i) {
        if (progress_list[i].upload_id == upload_id) {
            return &progress_list[i];
        }
    }

    return progress_list;
}

pprogress *add_progress_list(pprogress *progress_list, apr_uint32_t upload_id,
                             void *data)
{
    apr_time_t now;
    apr_size_t i;

    if (upload_id == 0) {
        return progress_list;
    }

    now = apr_time_now();

    // ȥξ
    // progress_list[i].end_time == 0        : ̤
    // progress_list[i].end_time == 1        : (åץ)
    // progress_list[i].end_time == ʳ : (åץɴλ)

    // Ʊ upload_id 뤫åĤĸŤȥ̤Ѿ֤ˡ
    for (i = 1; i < PROGRESS_LIST_NUMBER; ++i) {
        if (progress_list[i].end_time == 0) {
            continue;
        }

        if ((progress_list[i].end_time != 1) &&
            ((now - progress_list[i].end_time) > (PROGRESS_HOLD_SEC*APR_USEC_PER_SEC))) {
            memset(&(progress_list[i]), 0, sizeof(pprogress));
        } else if (progress_list[i].upload_id == upload_id) {
            return progress_list;
        }
    }

    // ̤ѥȥõϿ
    for (i = 1; i < PROGRESS_LIST_NUMBER; ++i) {
        if (progress_list[i].end_time == 0) {
            progress_list[i].upload_id  = upload_id;
            progress_list[i].total_size = 0;
            progress_list[i].read_size  = 0;
            progress_list[i].end_time   = 1;
            progress_list[i].data       = data;

            return &progress_list[i];
        }
    }

    return progress_list;
}

bool is_poster_list_contain(poster *poster_list, const char *address)
{
    apr_time_t now;
    apr_size_t i;

    now = apr_time_now();
    for (i = 0; i < POSTER_LIST_NUMBER; ++i) {
        if ((now - poster_list[i].time) > (POST_INTERVAL_SEC*APR_USEC_PER_SEC)) {
            break;
        }

        if (strcmp(poster_list[i].address, address) == 0) {
            return true;
        }
    }

    return false;
}

int poster_compare(const poster *a, const poster *b)
{
    return b->time > a->time;
}

void add_poster_list(poster *poster_list, const char *address)
{
    apr_time_t now;
    apr_size_t i, j;

    // poster_list ϻ˴Ťƾ˥ȤƤ롥

    // ڤΥȥõ
    now = apr_time_now();
    for (i = 0; i < POSTER_LIST_NUMBER; ++i) {
        if ((now - poster_list[i].time) > (POST_INTERVAL_SEC*APR_USEC_PER_SEC)) {
            break;
        }
    }

    //ڤΥȥ꤬Ĥʤä顤ָŤʪ
    if (i == POSTER_LIST_NUMBER) {
        i--;
    }

    // ƾϿ
    poster_list[i].time = now;
    strncpy(poster_list[i].address, address, sizeof(poster_list[i].address));
    j = i;

    // Ťȥ򥯥ꥢ
    while (++i < POSTER_LIST_NUMBER) {
        poster_list[i].time = 0;
    }

    // ɬ׺¤ϰϤȤʤ
    if (j != 0) {
        qsort(poster_list, j + 1, sizeof(poster),
              reinterpret_cast<int(*)(const void *, const void *)>(poster_compare));
    }
}

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
