#!/usr/bin/perl

use strict;

use File::Basename;
use Getopt::Long;
use Term::ReadPassword;
use WWW::SourceforgeJP;

use constant PROJECT    => 'mod-uploader';
use constant USER       => 'kimata';

my %args = ();
my $sf;

GetOptions(\%args, "package=s", "mode=s", "version=s", "file=s");

$sf = WWW::SourceforgeJP->new(PROJECT);
$sf->login(USER, read_password('sourceforge pass: ', 0, 1));

if ($args{'mode'} eq 'release') {
    die '--file ꤵƤޤ' unless (defined $args{'file'});
    die 'ե (' . $args{'file'} . ') ¸ߤޤ' unless (-e $args{'file'});

    $sf->create_release($args{'package'}, $args{'version'}, $args{'file'});
} else {
    my @links = $sf->get_release_links();
    my $src_link = (grep($_->text() =~ /^mod_uploader-.*\.tgz$/, @links))[0];
    my $win32_bin_link = (grep($_->text() =~ /^mod_uploader\.so-.*\.zip$/, @links))[0];

    while (<>) {
        if (/\* `mod_uploader-\d+\.\d+\.\d+\.tgz/) {
            print << "__HTML__";
* `@{[$src_link->text()]}[0] <@{[$src_link->url()]}[0]>`_
__HTML__
        } elsif (/\* `mod_uploader\.so-\d+\.\d+\.\d+\.zip/) {
            print << "__HTML__";
* `@{[$win32_bin_link->text()]}[0] <@{[$win32_bin_link->url()]}[0]>`_
__HTML__
        } else {
            print;
        }
    }
}

# Local Variables:
# mode: cperl
# buffer-file-coding-system: euc-japan-unix
# End:
