/******************************************************************************
 * Copyright (C) 2006 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: UploaderConfig.h 2124 2006-11-27 16:14:24Z svn $
 *****************************************************************************/

#ifndef UPLOADER_CONFIG_H
#define UPLOADER_CONFIG_H

#include "Environment.h"

#include <cstdlib>

#include "apr_shm.h"

#include "Macro.h"
#include "Uncopyable.h"

class PostFlowController;
class UploadItemList;
class UploadItemManager;
class UploaderTemplate;

using namespace std;

/**
 * @brief アップローダの設定を保持するクラス．
 */
class UploaderConfig: public Uncopyable
{
public:
    typedef struct Item {
        const char *param;
        const char *desc;
    } item_t;
    enum template_type_t {
        INDEX_VIEW,
        PROGRESS_VIEW,
        DOWNLOAD_VIEW,
        THUMBNAIL_VIEW,
        ADMIN_VIEW,
    };

    static const item_t BASE_URL;
    static const item_t DATA_DIRECTORY;
    static const item_t FILE_DIRECTORY;
    static const item_t THUMB_DIRECTORY;
    static const item_t TEMP_DIRECTORY;

    static const item_t TOTAL_FILE_SIZE;
    static const item_t TOTAL_FILE_NUMBER;
    static const item_t FILE_SIZE_LIMIT;
    static const item_t PER_PAGE_ITEM_NUMBER;

    static const item_t INDEX_VIEW_TEMPLATE;
    static const item_t PROGRESS_VIEW_TEMPLATE;
    static const item_t DOWNLOAD_VIEW_TEMPLATE;
    static const item_t THUMBNAIL_VIEW_TEMPLATE;
    static const item_t ADMIN_VIEW_TEMPLATE;

    UploaderConfig(apr_pool_t *pool);

    void init();
    void child_init();
    void finalize();

    void set_template(template_type_t type, const char *tmpl_file_path);

    UploadItemList *get_item_list() const
    {
        return item_list_;
    };
    UploadItemManager *get_item_manager() const
    {
        return item_manager_;
    };
    PostFlowController *get_flow_controller() const
    {
        return flow_controller_;
    };
    UploaderTemplate *get_template(template_type_t type)
    {
        if (UNLIKELY(is_debug_mode)) {
            update_template(type);
        }

        return tmpls_[type];
    };

    const char *to_string(apr_pool_t *pool);

    // 面倒なので public
    const char *base_url;
    const char *data_dir_path;
    const char *file_dir_path;
    const char *thumb_dir_path;
    const char *temp_dir_path;
    apr_uint64_t total_file_size_limit;
    apr_size_t total_file_number_limit;
    apr_uint64_t file_size_limit;
    apr_size_t per_page_item_number;
    bool is_debug_mode;

private:
    void check();
    void check_template();
    void load_template();
    void update_template(template_type_t type);

    apr_pool_t *pool_;

    apr_shm_t *list_shm_;
    apr_shm_t *manager_shm_;
    apr_shm_t *flow_controller_shm_;

    UploadItemList *item_list_;
    UploadItemManager *item_manager_;
    PostFlowController *flow_controller_;

    UploaderTemplate *tmpls_[5];
};

#endif

// Local Variables:
// mode: c++
// coding: utf-8-dos
// End:
