/******************************************************************************
 * Copyright (C) 2006 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: uploader_util.cpp 2122 2006-11-27 15:24:47Z svn $
 *****************************************************************************/

#include "Environment.h"

#include "apr_strings.h"

#include "uploader_util.h"

#include "UploaderConfig.h"
#include "UploadItemIO.h"
#include "PostFlowController.h"
#include "CharCodeConverter.h"
#include "Auxiliary.h"
#include "SourceInfo.h"

SOURCE_INFO_ADD("$Id: uploader_util.cpp 2122 2006-11-27 15:24:47Z svn $");

const char *get_word(apr_pool_t *pool, const char **input,
                     const char delimiter)
{
    const char *start;
    const char *end;

    start = end = *input;

    while ((*end != '\0') && (*end != delimiter)) {
        end++;
    }

    if (*end == '\0') {
        *input = end;
    } else {
        *input = end + 1;
    }

    if (end != start) {
        return apr_pstrmemdup(pool, start, end - start);
    } else {
        return "";
    }
}

void get_page(apr_pool_t *pool, const char *arg, apr_size_t *page_no)
{
    *page_no = atosize(get_word(pool, &arg, ARG_SEPARATE_STR[0]));

    if (*page_no == 0) {
        *page_no = 1;
    }
}

// void get_thread_id(apr_pool_t *pool, const char *arg, apr_size_t *thread_id)
// {
//     *thread_id = atosize(get_word(pool, &arg, ARG_SEPARATE_STR[0]));
// }

// void get_thread_param(apr_pool_t *pool, const char *arg, apr_size_t *thread_id,
//                       BBSCommentIterator::range_t **ranges,
//                       apr_size_t *range_count)
// {
//     const char *ranges_arg;
//     const char *range_arg;

//     // MEMO: PATH_INFO の長さ制限によって，range_count の大きさも制限される

//     *thread_id = atosize(get_word(pool, &arg, ARG_SEPARATE_STR[0]));

//     ranges_arg = get_word(pool, &arg, ARG_SEPARATE_STR[0]);
//     *range_count = get_range_count(ranges_arg);

//     if (*range_count == 0) {
//         *ranges = NULL;
//         return;
//     }

//     APR_PCALLOC(*ranges, BBSCommentIterator::range_t *, pool,
//                 sizeof(BBSCommentIterator::range_t) * (*range_count));

//     // 末尾からの個数指定
//     if (*ranges_arg == ARG_COMMENT_RANGE_LAST_STR[0]) {
//         (*ranges)[0].start_no = BBSCommentIterator::RANGE_FROM_LAST;
//         (*ranges)[0].stop_no = atoi(ranges_arg + 1);
//         return;
//     }

//     for (apr_size_t i = 0; i < *range_count; i++) {
//         range_arg = get_word(pool, &ranges_arg,
//                              ARG_COMMENT_RANGE_SEPARATE_CHAR);
//         (*ranges)[i].start_no = atoi(get_word(pool, &range_arg,
//                                               ARG_COMMENT_RANGE_INTERVAL_CHAR));

//         if ((*range_arg == '\0') &&
//             (*(range_arg-1) != ARG_COMMENT_RANGE_INTERVAL_CHAR)) {
//             (*ranges)[i].stop_no = (*ranges)[i].start_no;
//         } else {
//             (*ranges)[i].stop_no = atoi(range_arg);
//         }
//     }
// }

// void get_thumbnail_size(ImageFile *image_file,
//                         apr_uint16_t *width, apr_uint16_t *height)
// {
//     static const double THUMBAIL_ASPECT =
//         static_cast<double>(VIW_THUMBNAIL_WIDTH_LIMIT)/VIW_THUMBNAIL_HEIGHT_LIMIT;

//     *width = image_file->get_width();
//     *height = image_file->get_height();

//     if (((*width) == 0) || ((*height) == 0)) {
//         THROW(MESSAGE_POST_IMAGE_SIZE_INVALID);
//     }

//     if ((static_cast<double>(*width)/(*height)) > THUMBAIL_ASPECT) {
//         // 横長の場合
//         if ((*width) > VIW_THUMBNAIL_WIDTH_LIMIT) {
//             *height = (*height) * VIW_THUMBNAIL_WIDTH_LIMIT / (*width);
//             *width = VIW_THUMBNAIL_WIDTH_LIMIT;
//         }
//     } else {
//         // 縦長の場合
//         if ((*height) > VIW_THUMBNAIL_HEIGHT_LIMIT) {
//             *width = (*width) * VIW_THUMBNAIL_HEIGHT_LIMIT / (*height);
//             *height = VIW_THUMBNAIL_HEIGHT_LIMIT;
//         }
//     }

//     if (((*width) == 0) || ((*height) == 0)) {
//         THROW(MESSAGE_POST_IMAGE_SIZE_INVALID);
//     }
// }

const char *get_dispos_encoding(const char *user_agent)
{
    const char *encoding;

    encoding = CharCodeConverter::DEFAULT_CODE;

    if (user_agent == NULL) {
        return encoding;
    }

    // だー．激しく場当たり的．
    if ((strstr(user_agent, "compatible; MSIE") != NULL) ||
        (strstr(user_agent, "Sleipnir") != NULL)) {
        encoding = IE_NAME_ENCODING;
    } else if ((strstr(user_agent, "Firefox") != NULL) ||
               (strstr(user_agent, "Mozilla") != NULL)) {
        encoding = FIREFOX_NAME_ENCODING;
    }

    return encoding;
}

bool can_post(UploaderConfig *config, const char *url)
{
    if (config->is_debug_mode) {
        return true;
    }

    return config->get_flow_controller()->can_post(url);
}

void regist_post(UploaderConfig *config, const char *url)
{
    if (config->is_debug_mode) {
        return;
    }

    config->get_flow_controller()->regist_post(url);
}

// Local Variables:
// mode: c++
// coding: utf-8-dos
// End:
