/******************************************************************************
 * Copyright (C) 2006 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: CGIResponse.h 2130 2006-11-27 17:54:25Z svn $
 *****************************************************************************/

#ifndef CGI_RESPONSE_H
#define CGI_RESPONSE_H

#include "Environment.h"

#include <iostream>

#include "apr_strings.h"
#include "apr_tables.h"
#include "apr_time.h"
#include "apr_env.h"

#include "Uncopyable.h"

using namespace std;

class CGIRequestReader;
class CGIResponseWriter;

static const int OK                                 = 0;
static const int HTTP_TEMPORARY_REDIRECT            = 307;
static const int HTTP_BAD_REQUEST                   = 400;

/**
 * @brief CGI のレスポンスを表すクラス．
 */
class CGIResponse {
public:
    typedef struct Handle {
        apr_pool_t *pool;

        Handle(apr_pool_t *pool_arg)
          : pool(pool_arg)
        {

        };
    } Handle;
    typedef CGIRequestReader  Reader;
    typedef CGIResponseWriter Writer;

    static const char *get_request_uri(Handle *r)
    {
        char *uri;

        if (apr_env_get(&uri, "REQUEST_URI", r->pool) != APR_SUCCESS) {
            THROW(MESSAGE_SYS_ENV_VARIABLE_INVALID);
        }

        return uri;
    };
    static const char *get_content_type(Handle *r)
    {
        char *content_type;

        if (apr_env_get(&content_type, "Content-Type",
                        r->pool) != APR_SUCCESS) {
            THROW(MESSAGE_SYS_ENV_VARIABLE_INVALID);
        }

        return content_type;
    };
    static apr_size_t get_content_size(Handle *r)
    {
        char *content_size;

        if (apr_env_get(&content_size, "Content-Length",
                        r->pool) != APR_SUCCESS) {
            THROW(MESSAGE_SYS_ENV_VARIABLE_INVALID);
        }

        return static_cast<apr_size_t>(apr_atoi64(content_size));
    };
    static const char *get_query(Handle *r)
    {
        char *query;

        if (apr_env_get(&query, "QUERY_STRING", r->pool) != APR_SUCCESS) {
            THROW(MESSAGE_SYS_ENV_VARIABLE_INVALID);
        }

        return query;
    };
    static const char *get_remote_ip(Handle *r)
    {
        char *remote_ip;

        if (apr_env_get(&remote_ip, "REMOTE_ADDR", r->pool) != APR_SUCCESS) {
            THROW(MESSAGE_SYS_ENV_VARIABLE_INVALID);
        }

        return remote_ip;
    };
    static const char *get_user_agent(Handle *r)
    {
        char *agent;

        if (apr_env_get(&agent, "USER_AGENT", r->pool) != APR_SUCCESS) {
            THROW(MESSAGE_SYS_ENV_VARIABLE_INVALID);
        }

        return agent;
    };
    static bool is_head_method(Handle *r)
    {
        char *request_method;

        if (apr_env_get(&request_method, "REQUEST_METHOD",
                        r->pool) != APR_SUCCESS) {
            THROW(MESSAGE_SYS_ENV_VARIABLE_INVALID);
        }
        return (strcmp(request_method, "HEAD") == 0);
    };
    static bool is_post_method(Handle *r)
    {
        char *request_method;

        if (apr_env_get(&request_method, "REQUEST_METHOD",
                        r->pool) != APR_SUCCESS) {
            THROW(MESSAGE_SYS_ENV_VARIABLE_INVALID);
        }
        return (strcmp(request_method, "POST") == 0);
    };
    static int is_meets_condition(Handle *r)
    {
        return OK;
    };
    static int prepare_post_read(Handle *r)
    {
        return OK;
    };
    static void set_modified_time(Handle *r, apr_time_t time)
    {

    };
    static void set_last_modified(Handle *r, apr_time_t time)
    {

    };
    static void set_content_type(Handle *r, const char *content_type)
    {
        cout << "Conten-type: " << content_type << "\r\n\r\n";
    };
    static void set_accept_ranges(Handle *r)
    {
        cout << "Accept-Ranges: bytes\r\n";
    }
    static void set_location(Handle *r, const char *uri)
    {
        cout << "Location: " << uri << "\r\n\r\n";
    };
    static void set_content_disposition(Handle *r, const char *dispos)
    {
        cout << "Content-Disposition: " << dispos << "\r\n";
    };
};

#include "CGIResponseWriter.h"

#endif

// Local Variables:
// mode: c++
// coding: utf-8-dos
// End:
