/******************************************************************************
 * Copyright (C) 2006 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: MessageEN.h 2147 2006-12-01 17:59:57Z svn $
 *****************************************************************************/

#ifndef MESSAGE_EN_H
#define MESSAGE_EN_H

/**
 * @file
 * @brief Error eessages in English.
 */
#define MESSAGE_ARGUMENT_INVALID            "MESSAGE_ARGUMENT_INVALID"
#define MESSAGE_BUG_FOUND                   "MESSAGE_BUG_FOUND"
#define MESSAGE_CONF_FILE_NOT_FOUND         "MESSAGE_CONF_FILE_NOT_FOUND"
#define MESSAGE_CONF_PARAM_COMPULSORY_NOT_SPECIFIED "MESSAGE_CONF_PARAM_COMPULSORY_NOT_SPECIFIED"
#define MESSAGE_CONF_TEMPLATE_INITIALIZE_FAILED "MESSAGE_CONF_TEMPLATE_INITIALIZE_FAILED"
#define MESSAGE_DATA_DIR_NOT_FOUND          "MESSAGE_DATA_DIR_PATH_NOT_FOUND"
#define MESSAGE_DIGEST_STATE_INVALID        "MESSAGE_DIGEST_STATE_INVALID"
#define MESSAGE_DIR_OPEN_FAILED             "MESSAGE_DIR_OPEN_FAILED"
#define MESSAGE_FILE_DIFFER                 "MESSAGE_FILE_DIFFER"

#define MESSAGE_ICONV_CONVERTER_NOT_FOUND   "MESSAGE_ICONV_CONVERTER_NOT_FOUND"
#define MESSAGE_ICONV_ENCODING_INVALID      "MESSAGE_ICONV_ENCODING_INVALID"

#define MESSAGE_REMOVE_PASS_MISMATCH        "MESSAGE_REMOVE_PASS_MISMATCH"

#define MESSAGE_FILE_EXT_INVALID            "MESSAGE_FILE_EXT_INVALID"
#define MESSAGE_FILE_MIME_INVALID           "MESSAGE_FILE_MIME_INVALID"
#define MESSAGE_FILE_MMAP_DOUBLED           "MESSAGE_FILE_MMAP_DOUBLED"
#define MESSAGE_FILE_MMAP_FAILED            "MESSAGE_FILE_MMAP_FAILED"
#define MESSAGE_FILE_MMAP_INVALID_FILE      "MESSAGE_FILE_MMAP_INVALID_FILE"
#define MESSAGE_FILE_NOT_FOUND              "MESSAGE_FILE_NOT_FOUND"
#define MESSAGE_FILE_OPEN_FAILED            "MESSAGE_FILE_OPEN_FAILED"
#define MESSAGE_FILE_PATH_CREATION_FAILED   "MESSAGE_FILE_PATH_CREATION_FAILED"
#define MESSAGE_FILE_READ_FAILED            "MESSAGE_FILE_READ_FAILED"
#define MESSAGE_FILE_REMOVE_FAILED          "MESSAGE_FILE_REMOVE_FAILED"
#define MESSAGE_FILE_RENAME_FAILED          "MESSAGE_FILE_RENAME_FAILED"
#define MESSAGE_FILE_COPY_FAILED            "MESSAGE_FILE_COPY_FAILED"
#define MESSAGE_FILE_SEEK_FAILED            "MESSAGE_FILE_SEEK_FAILED"
#define MESSAGE_FILE_STATE_INVALID          "MESSAGE_FILE_STATE_INVALID"
#define MESSAGE_FILE_STAT_FAILED            "MESSAGE_FILE_STAT_FAILED"
#define MESSAGE_FILE_TRUNC_FAILED           "MESSAGE_FILE_TRUNC_FAILED"
#define MESSAGE_FILE_WRITE_FAILED           "MESSAGE_FILE_WRITE_FAILED"
#define MESSAGE_HANDLER_COMMAND_INVALID     "MESSAGE_HANDLER_COMMAND_INVALID"
#define MESSAGE_HNDL_PATH_INFO_TOO_LONG     "MESSAGE_HNDL_PATH_INFO_TOO_LONG"
#define MESSAGE_MANAGER_SHOULD_LOCKED       "MESSAGE_MANAGER_SHOULD_LOCKED"
#define MESSAGE_MANAGER_SHOULD_NOT_LOCKED   "MESSAGE_MANAGER_SHOULD_NOT_LOCKED"
#define MESSAGE_MUTEX_LOCK_FAILED           "MESSAGE_MUTEX_LOCK_FAILED"
#define MESSAGE_MUTEX_UNLOCK_FAILED         "MESSAGE_MUTEX_UNLOCK_FAILED"
#define MESSAGE_POOL_CREATION_FAILED        "MESSAGE_POOL_CREATION_FAILED"
#define MESSAGE_POST_COMMENT_EMPTY          "MESSAGE_POST_COMMENT_EMPTY"
#define MESSAGE_POST_COMMENT_TOO_LONG       "MESSAGE_POST_COMMENT_TOO_LONG"
#define MESSAGE_POST_DOWNLOAD_PASS_TOO_LONG "MESSAGE_POST_DOWNLOAD_PASS_TOO_LONG"
#define MESSAGE_POST_FILE_DIGEST_EMPTY      "MESSAGE_POST_FILE_DIGEST_EMPTY"
#define MESSAGE_POST_FILE_DIGEST_TOO_LONG   "MESSAGE_POST_FILE_DIGEST_TOO_LONG"
#define MESSAGE_POST_FILE_EXT_EMPTY         "MESSAGE_POST_FILE_EXT_EMPTY"
#define MESSAGE_POST_FILE_EXT_TOO_LONG      "MESSAGE_POST_FILE_EXT_TOO_LONG"
#define MESSAGE_POST_FILE_MIME_EMPTY        "MESSAGE_POST_FILE_MIME_EMPTY"
#define MESSAGE_POST_FILE_MIME_TOO_LONG     "MESSAGE_POST_FILE_MIME_TOO_LONG"
#define MESSAGE_POST_FILE_NAME_EMPTY        "MESSAGE_POST_FILE_NAME_EMPTY"
#define MESSAGE_POST_FILE_NAME_INVALID      "MESSAGE_POST_FILE_NAME_INVALID"
#define MESSAGE_POST_FILE_NAME_TOO_LONG     "MESSAGE_POST_FILE_NAME_TOO_LONG"
#define MESSAGE_POST_READ_FAILED            "MESSAGE_POST_READ_FAILED"
#define MESSAGE_POST_REMOVE_PASS_TOO_LONG   "MESSAGE_POST_REMOVE_PASS_TOO_LONG"
#define MESSAGE_PROGRAM_TOO_OLD             "MESSAGE_PROGRAM_TOO_OLD"
#define MESSAGE_RFC1867_CONTENT_SIZE_ZERO   "MESSAGE_RFC1867_CONTENT_SIZE_ZERO"
#define MESSAGE_RFC1867_CONTENT_TYPE_INVALID "MESSAGE_RFC1867_CONTENT_TYPE_INVALID"
#define MESSAGE_RFC1867_DATA_SIZE_TOO_LARGE "MESSAGE_RFC1867_DATA_SIZE_TOO_LARGE"
#define MESSAGE_RFC1867_FILE_SIZE_TOO_LARGE "MESSAGE_RFC1867_FILE_SIZE_TOO_LARGE"
#define MESSAGE_RFC1867_FORMAT_INVALID      "MESSAGE_RFC1867_FORMAT_INVALID"
#define MESSAGE_RFC1867_ITEM_COUNT_EXCEEDED "MESSAGE_RFC1867_ITEM_COUNT_EXCEEDED"
#define MESSAGE_RFC1867_TEXT_SIZE_TOO_LARGE "MESSAGE_RFC1867_TEXT_SIZE_TOO_LARGE"
#define MESSAGE_SHM_ATTACH_FAILED           "MESSAGE_SHM_ATTACH_FAILED"
#define MESSAGE_SHM_CREATION_FAILED         "MESSAGE_SHM_CREATION_FAILED"
#define MESSAGE_SHM_SIZE_INVALID            "MESSAGE_SHM_SIZE_INVALID"
#define MESSAGE_SYS_ATOMIC_INITIALIZE_FAILED "MESSAGE_SYS_ATOMIC_INITIALIZE_FAILED"
#define MESSAGE_SYS_MEMORY_ALLOC_FAILED     "MESSAGE_SYS_MEMORY_ALLOC_FAILED"
#define MESSAGE_TMPL_ARITHMETIC_PARSE_FAILED "MESSAGE_TMPL_ARITHMETIC_PARSE_FAILED"
#define MESSAGE_TMPL_ASSIGN_PARSE_FAILED    "MESSAGE_TMPL_ASSIGN_PARSE_FAILED"
#define MESSAGE_TMPL_BROKEN                 "MESSAGE_TMPL_BROKEN"
#define MESSAGE_TMPL_COMPARE_PARSE_FAILED   "MESSAGE_TMPL_COMPARE_PARSE_FAILED"
#define MESSAGE_TMPL_ELSE_PARSE_FAILED      "MESSAGE_TMPL_ELSE_PARSE_FAILED"
#define MESSAGE_TMPL_EXPR_PARSE_FAILED      "MESSAGE_TMPL_EXPR_PARSE_FAILED"
#define MESSAGE_TMPL_FILE_NOT_FOUND         "MESSAGE_TMPL_FILE_NOT_FOUND"
#define MESSAGE_TMPL_FOREACH_PARSE_FAILED   "MESSAGE_TMPL_FOREACH_PARSE_FAILED"
#define MESSAGE_TMPL_IF_PARSE_FAILED        "MESSAGE_TMPL_IF_PARSE_FAILED"
#define MESSAGE_TMPL_MULTIPLY_PARSE_FAILED  "MESSAGE_TMPL_MULTIPLY_PARSE_FAILED"
#define MESSAGE_TMPL_STMT_PARSE_FAILED      "MESSAGE_TMPL_STMT_PARSE_FAILED"
#define MESSAGE_TMPL_STRING_ENDED           "MESSAGE_TMPL_STRING_ENDED"
#define MESSAGE_TMPL_TERM_PARSE_FAILED      "MESSAGE_TMPL_TERM_PARSE_FAILED"
#define MESSAGE_TMPL_TOKEN_INVALID          "MESSAGE_TMPL_TOKEN_INVALID"
#define MESSAGE_TMPL_VARIABLE_ENDED         "MESSAGE_TMPL_VARIABLE_ENDED"
#define MESSAGE_TMPL_VARIABLE_FORMAT_INVALID "MESSAGE_TMPL_VARIABLE_FORMAT_INVALID"
#define MESSAGE_TMPL_VARIABLE_NAME_INVALID  "MESSAGE_TMPL_VARIABLE_NAME_INVALID"
#define MESSAGE_TMPL_VARIABLE_PARSE_FAILED  "MESSAGE_TMPL_VARIABLE_PARSE_FAILED"
#define MESSAGE_TMPL_WHILE_PARSE_FAILED     "MESSAGE_TMPL_WHILE_PARSE_FAILED"
#define MESSAGE_UPLOAD_ITEM_DIR_OPEN_FAILED "MESSAGE_UPLOAD_ITEM_DIR_OPEN_FAILED"
#define MESSAGE_UPLOAD_ITEM_FILE_PATH_CREATION_FAILED "MESSAGE_UPLOAD_ITEM_FILE_PATH_CREATION_FAILED"
#define MESSAGE_UPLOAD_ITEM_FORMAT_INVALID  "MESSAGE_UPLOAD_ITEM_FORMAT_INVALID"
#define MESSAGE_UPLOAD_ITEM_SUB_DIR_CREATION_FAILED "MESSAGE_UPLOAD_ITEM_SUB_DIR_CREATION_FAILED"
#define MESSAGE_UPLOAD_ITEM_SUB_DIR_OPEN_FAILED "MESSAGE_UPLOAD_ITEM_SUB_DIR_OPEN_FAILED"
#define MESSAGE_UPLOAD_ITEM_SUB_DIR_PATH_CREATION_FAILED "MESSAGE_UPLOAD_ITEM_SUB_DIR_PATH_CREATION_FAILED"
#define MESSAGE_UPLOAD_ITEM_SUB_DIR_PATH_CREATION_FAILED "MESSAGE_UPLOAD_ITEM_SUB_DIR_PATH_CREATION_FAILED"

#define MESSAGE_LIST_ID_INVALID             "MESSAGE_LIST_ID_INVALID"

#define MESSAGE_TEST_IP_ADDRESS             "MESSAGE_TEST_IP_ADDRESS"
#define MESSAGE_TEST_FILE_DIGEST            "d41d8cd98f00b204e9800998ecf8427e"
#define MESSAGE_TEST_REMOVE_PASS            "pass"
#define MESSAGE_TEST_DOWNLOAD_PASS          ""
#define MESSAGE_TEST_COMMENT                "MESSAGE_TEST_COMMENT"



// #define MESSAGE_BBS_COMMENT_WRITE_FAILED    "MESSAGE_BBS_COMMENT_WRITE_FAILED"
// #define MESSAGE_BBS_THREAD_COMMENT_ADD_FORBIDDEN "MESSAGE_BBS_THREAD_COMMENT_ADD_FORBIDDEN"
// #define MESSAGE_BBS_THREAD_DATA_MISMATCH    "MESSAGE_BBS_THREAD_DATA_MISMATCH"
// #define MESSAGE_BBS_THREAD_DIR_OPEN_FAILED  "MESSAGE_BBS_THREAD_DIR_OPEN_FAILED"
// #define MESSAGE_BBS_THREAD_FILE_PATH_CREATION_FAILED  "MESSAGE_BBS_THREAD_FILE_PATH_CREATION_FAILED"
// #define MESSAGE_BBS_THREAD_FORMAT_INVALID   "MESSAGE_BBS_THREAD_FORMAT_INVALID"
// #define MESSAGE_BBS_THREAD_SHOULD_LOCKED    "MESSAGE_BBS_THREAD_SHOULD_LOCKED"
// #define MESSAGE_BBS_THREAD_SHOULD_NOT_LOCKED "MESSAGE_BBS_THREAD_SHOULD_NOT_LOCKED"
// #define MESSAGE_BBS_THREAD_SHOULD_NOT_REFERRED "MESSAGE_BBS_THREAD_SHOULD_NOT_REFERRED"
// #define MESSAGE_BBS_THREAD_SIZE_MISMATCH    "MESSAGE_BBS_THREAD_SIZE_MISMATCH"
// #define MESSAGE_BBS_THREAD_SUB_DIR_CREATION_FAILED "MESSAGE_BBS_THREAD_SUB_DIR_CREATION_FAILED"
// #define MESSAGE_BBS_THREAD_SUB_DIR_OPEN_FAILED "MESSAGE_BBS_THREAD_SUB_DIR_OPEN_FAILED"
// #define MESSAGE_BBS_THREAD_SUB_DIR_PATH_CREATION_FAILED "MESSAGE_BBS_THREAD_SUB_DIR_PATH_CREATION_FAILED"
// #define MESSAGE_COMMENT_COUNT_EXCEEDED      "MESSAGE_COMMENT_COUNT_EXCEEDED"
// #define MESSAGE_COMMENT_NUMBER_INVALID      "MESSAGE_COMMENT_NUMBER_INVALID"
// #define MESSAGE_COMMENT_RANGE_INVALID       "MESSAGE_COMMENT_RANGE_INVALID"
// #define MESSAGE_CONDITION_CREATION_FAILED   "MESSAGE_CONDITION_CREATION_FAILED"
// #define MESSAGE_CONDITION_SIGNAL_FAILED     "MESSAGE_CONDITION_SIGNAL_FAILED"
// #define MESSAGE_CONDITION_WAIT_FAILED       "MESSAGE_CONDITION_WAIT_FAILED"
#define MESSAGE_CONF_ASSIGN_NEEDED          "MESSAGE_CONF_ASSIGN_NEEDED"
// #define MESSAGE_CONF_FILE_NOT_FOUND         "MESSAGE_CONF_FILE_NOT_FOUND"
// #define MESSAGE_CONF_PARAM_INVALID          "MESSAGE_CONF_PARAM_INVALID"
#define MESSAGE_CONF_QUOTE_ENDED            "MESSAGE_CONF_QUOTE_ENDED"
#define MESSAGE_CONF_RETURN_NEEDED          "MESSAGE_CONF_RETURN_NEEDED"
// #define MESSAGE_DAT_FILE_NOT_FOUND          "MESSAGE_DAT_FILE_PATH_NOT_FOUND"
#define MESSAGE_ENVIRONMENT_LOCATION_DIR_EXIST "MESSAGE_ENVIRONMENT_LOCATION_DIR_EXIST"
// #define MESSAGE_EXCEPTION_BUG_FOUND                   "MESSAGE_EXCEPTION_BUG_FOUND"
// #define MESSAGE_FILE_DUP_FAILED             "MESSAGE_FILE_DUP_FAILED"
// #define MESSAGE_FILE_SEEK_FAILED            "MESSAGE_FILE_SEEK_FAILED"
// #define MESSAGE_INITIALIZE_IMCOMPLETE       "MESSAGE_INITIALIZE_IMCOMPLETE"
// #define MESSAGE_MUTEX_ATTACH_FAILED         "MESSAGE_MUTEX_ATTACH_FAILED"
// #define MESSAGE_MUTEX_CHANGE_PERMISSION_FAILED "MESSAGE_MUTEX_CHANGE_PERMISSION_FAILED"
// #define MESSAGE_MUTEX_CREATION_FAILED       "MESSAGE_MUTEX_CREATION_FAILED"
#define MESSAGE_POST_DATA_INVALID           "MESSAGE_POST_INVALID_DATA"
// #define MESSAGE_POST_EMAIL_HTML_FORBIDDEN   "MESSAGE_POST_EMAIL_HTML_FORBIDDEN"
// #define MESSAGE_POST_EMAIL_TOO_LONG         "MESSAGE_POST_EMAIL_TOO_LONG"
// #define MESSAGE_POST_IMAGE_COMMIT_FAILED    "MESSAGE_POST_IMAGE_COMMIT_FAILED"
// #define MESSAGE_POST_IMAGE_PATH_CREATION_FAILED "MESSAGE_POST_IMAGE_PATH_CREATION_FAILED"
#define MESSAGE_POST_IMAGE_SIZE_INVALID     "MESSAGE_POST_IMAGE_SIZE_INVALID"
// #define MESSAGE_POST_INTERVAL_TOO_SHORT     "MESSAGE_POST_INTERVAL_TOO_SHORT"
// #define MESSAGE_POST_MESSAGE_EMPTY          "MESSAGE_POST_MESSAGE_EMPTY"
// #define MESSAGE_POST_MESSAGE_TOO_LONG       "MESSAGE_POST_MESSAGE_TOO_LONG"
// #define MESSAGE_POST_NAME_EMPTY             "MESSAGE_POST_NAME_EMPTY"
// #define MESSAGE_POST_NAME_HTML_FORBIDDEN    "MESSAGE_POST_NAME_HTML_FORBIDDEN"
// #define MESSAGE_POST_NAME_TOO_LONG          "MESSAGE_POST_NAME_TOO_LONG"
// #define MESSAGE_POST_SUBJECT_EMPTY          "MESSAGE_POST_SUBJECT_EMPTY"
// #define MESSAGE_POST_SUBJECT_TOO_LONG       "MESSAGE_POST_SUBJECT_TOO_LONG"
// #define MESSAGE_POST_THUMBNAIL_PATH_CREATION_FAILED "MESSAGE_POST_THUMBNAIL_PATH_CREATION_FAILED"
// #define MESSAGE_POST_TRIP_HTML_FORBIDDEN    "MESSAGE_POST_TRIP_HTML_FORBIDDEN"
// #define MESSAGE_POST_TRIP_TOO_LONG          "MESSAGE_POST_TRIP_TOO_LONG"
#define MESSAGE_SYS_ENV_VARIABLE_INVALID    "MESSAGE_SYS_ENV_VARIABLE_INVALID"
// #define MESSAGE_THREAD_CREATION_FAILED      "MESSAGE_THREAD_CREATION_FAILED"
#define MESSAGE_TMPL_ARRAY_TYPE_MISMATCH    "MESSAGE_TMPL_ARRAY_TYPE_MISMATCH"
#define MESSAGE_TMPL_ASSIGN_CALC_FAILED     "MESSAGE_TMPL_ASSIGN_CALC_FAILED"
#define MESSAGE_TMPL_ASSIGN_TYPE_MISMATCH   "MESSAGE_TMPL_ASSIGN_TYPE_MISMATCH"
// #define MESSAGE_TMPL_EXPR_LIST_PARSE_FAILED "MESSAGE_TMPL_EXPR_LIST_PARSE_FAILED"
#define MESSAGE_TMPL_FOREACH_EXEC_FAILED    "MESSAGE_TMPL_FOREACH_EXEC_FAILED"
#define MESSAGE_TMPL_HASH_TYPE_MISMATCH     "MESSAGE_TMPL_HASH_TYPE_MISMATCH"
#define MESSAGE_TMPL_IF_EXEC_FAILED         "MESSAGE_TMPL_IF_EXEC_FAILED"
#define MESSAGE_TMPL_INTEGER_TYPE_MISMATCH  "MESSAGE_TMPL_INTEGER_TYPE_MISMATCH"
#define MESSAGE_TMPL_PRINT_EXEC_FAILED      "MESSAGE_TMPL_PRINT_EXEC_FAILED"
// #define MESSAGE_TMPL_PRINT_PARSE_FAILED     "MESSAGE_TMPL_PRINT_PARSE_FAILED"
#define MESSAGE_TMPL_SCALAR_TYPE_MISMATCH   "MESSAGE_TMPL_SCALAR_TYPE_MISMATCH"
#define MESSAGE_TMPL_STMT_LIST_EXEC_FAILED  "MESSAGE_TMPL_STMT_LIST_EXEC_FAILED"
#define MESSAGE_TMPL_UNINITIALIZED_VAR_REFERRED "MESSAGE_TMPL_UNINITIALIZED_VAR_REFERRED"
#define MESSAGE_TMPL_WHILE_EXEC_FAILED      "MESSAGE_TMPL_WHILE_EXEC_FAILED"


#endif

// Local Variables:
// mode: c++
// coding: utf-8-dos
// End:
