/******************************************************************************
 * Copyright (C) 2006 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: ReadLocker.h 2256 2006-12-13 10:28:14Z svn $
 *****************************************************************************/

#ifndef READ_LOCKER_H
#define READ_LOCKER_H

#include "Environment.h"

#include "ReadWriteLocker.h"
#include "Macro.h"

#ifdef DEBUG
#include <iostream>
#endif

using namespace std;

/**
 * @brief 読み出しロックを表すクラス．
 */
class ReadLocker: public ReadWriteLocker
{
public:
    /**
     * コンストラクタです．
     *
     * @param[out] read_count 読み出し中のスレッドの数
     */
    ReadLocker(apr_atomic_t *read_count)
      : ReadWriteLocker(read_count)
    {
        apr_uint32_t curr_count;

        while (1) {
            curr_count = apr_atomic_read(read_count_);
            if (UNLIKELY(curr_count == WRITE_LOCKED)) {
                yield();
                continue;
            }

            if (UNLIKELY(apr_atomic_cas(read_count_, curr_count + 1, curr_count)
                         != curr_count)) {
                yield();
                continue;
            }

            MEMORY_BARRIER;
            return;
        }
    };
    ~ReadLocker()
    {
        (void)apr_atomic_dec(read_count_);
    };
    static bool is_locked(apr_atomic_t *read_count) {
        return apr_atomic_read(read_count) != 0;
    };
};

#endif

// Local Variables:
// mode: c++
// coding: utf-8-dos
// End:
