/******************************************************************************
 * Copyright (C) 2006 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: PostDataChecker.h 2271 2006-12-16 20:15:22Z svn $
 *****************************************************************************/

#ifndef POST_DATA_CHECKER_H
#define POST_DATA_CHECKER_H

#include "Environment.h"

#include "apr.h"

#include <cstdlib>

#include "UploadItem.h"
#include "Uncopyable.h"

using namespace std;

/**
 * @brief 書き込みデータのチェックを行うクラス．
 */
class PostDataChecker: public Uncopyable
{
public:
    static void validate_uitem(apr_pool_t *pool, apr_off_t file_size,
                               apr_time_t  mtime, const char **file_name,
                               const char **file_mime, const char *file_digest,
                               const char *remove_pass,
                               const char *download_pass,
                               const char **comment);
private:
    static const char HTML_EXT[];

    static void validate_file_name(apr_pool_t *pool, const char **file_name);
    static void validate_comment(apr_pool_t *pool, const char **comment);
    static void validate_file_ext(const char *file_ext);
};

#endif

// Local Variables:
// mode: c++
// coding: utf-8-dos
// End:
